//=============================================================================
// LIPATCReplace.
// Made by HL2MonstersLite3 UT2004 Mod author, really thanks to him/her...
//=============================================================================
class LIPATCReplace extends Mutator
    config;

var string ArenaVehicleClassName;		// Your vehicle class
var config string FactoryVehicleClassName;	// The default vehicle to replace

var class<SVehicle> ArenaVehicleClass;
var class<SVehicle> FactoryVehicleClass;
var localized string ArenaDisplayText;		// The line that shows up in the config menu (ie: "Replace this vehicle with the Flak Scorpion")
var localized string ArenaDescText;		// The description of the option.

function PostBeginPlay()
{
	local ONSVehicleFactory Factory;

	FactoryVehicleClass = class<SVehicle>( DynamicLoadObject(FactoryVehicleClassName,class'Class') );
	ArenaVehicleClass = class<SVehicle>( DynamicLoadObject(ArenaVehicleClassName,class'Class') );

	if(ArenaVehicleClass != None)
	{
		foreach AllActors( class 'ONSVehicleFactory', Factory )
		{
			if (Factory.VehicleClass == FactoryVehicleClass)
				Factory.VehicleClass = ArenaVehicleClass;
		}
	}

	Super.PostBeginPlay();
}

static function FillPlayInfo(PlayInfo PlayInfo)
{
	local array<CacheManager.VehicleRecord> Recs;
	local string VehicleOptions;
	local int i;
	local class<SVehicle> v;

	Super.FillPlayInfo(PlayInfo);

	class'CacheManager'.static.GetVehicleList(Recs);

	VehicleOptions = ";";

	for (i = 0; i < Recs.Length; i++)
	{
		v = class<SVehicle>(DynamicLoadObject(Recs[i].ClassName, class'class', false));
		if (v != None)
			VehicleOptions $= ";" $ Recs[i].ClassName $ ";" $ Recs[i].FriendlyName;
	}

	PlayInfo.AddSetting(default.RulesGroup, "FactoryVehicleClassName", default.ArenaDisplayText, 0, 1, "Select", VehicleOptions);

	return;
}


static event string GetDescriptionText(string PropName)
{
	if (PropName == "FactoryVehicleClassName")
		return default.ArenaDescText;

	return Super.GetDescriptionText(PropName);
}

/*
	The defaults of my Flak Scorpion
*/

defaultproperties
{
     ArenaVehicleClassName="LIPATC.LIPVehicleAtomicToiletCar"
     FactoryVehicleClassName="Onslaught.ONSRV"
     ArenaDisplayText="Use LIP ATC instead of:"
     ArenaDescText="Replace any vehicle with the LIP ATC."
     GroupName="LIPATCGroup"
     FriendlyName="LIPATCReplace"
     Description="Replace any vehicle with the LIP ATC."
}
