//----------------------//
// JetpackInvAttachment //
//----------------------//

class JetpackInvAttachment extends InventoryAttachment;

#exec OBJ LOAD FILE=JetPackMesh.ukx name=JetPackMesh

var	Emitter ST1, ST2;
var int Armor;
var bool bDying;

replication
{
	reliable if (Role == ROLE_Authority)
		ClientSetDying;
}

simulated function StartTrail()
{
	local coords c;

	if (Level.NetMode != NM_DedicatedServer)
	{
		if (ST1 == None)
		{
			c = GetBoneCoords('L_EngineExhaust');
			ST1 = Spawn(class'JetpackSmokeTrail', self,, c.origin);
			ST1.SetBase(self);
		}
		if (ST2 == None)
		{
			c = GetBoneCoords('R_EngineExhaust');
			ST2 = Spawn(class'JetpackSmokeTrail', self,, c.Origin);
			ST2.SetBase(self);
		}
		LightType = LT_Steady;
		bDynamicLight = True;
		AmbientSound = Sound'WeaponSounds.redeemer_flight';
	}

	return;
}

simulated function StopTrail()
{
	if (Level.NetMode != NM_DedicatedServer)
	{
		if (ST1 != None)
		{
			ST1.Kill();
			ST1 = None;
		}
		if (ST2 != none)
		{
			ST2.Kill();
			ST2 = none;
		}
		LightType = LT_None;
		bDynamicLight = False;
		AmbientSound = None;
	}

	return;
}

function SetDying()
{
	local Rotator r;
	local JetpackDeadActor JDA;

	r.Pitch = Rand(32768) + 16384;
	r.Yaw = Rand(32768) + 16384;
	r.Roll = Rand(32768);
	bDying = True;

	if (Level.NetMode != NM_DedicatedServer)
	{
		JDA = Spawn(class'JetpackDeadActor',,, Location, Rotation);
		JDA.RotationRate = r;
		JDA.DesiredRotation = JDA.Rotation + r * 2.0;
		JDA.StartTrail();
	}

	ClientSetDying(r);
	StopTrail();
	Destroy();

	return;
}

simulated function ClientSetDying(Rotator r)
{
	local JetpackDeadActor JDA;

	bDying = True;

	if (Level.NetMode == NM_Client)
	{
		JDA = Spawn(class'JetpackDeadActor',,, Location, Rotation);
		JDA.RotationRate = r;
		JDA.DesiredRotation = JDA.Rotation + r * 2.0;
		JDA.StartTrail();
	}

	Destroy();

	return;
}

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	SetRelativeLocation(vect(-20.0,0.0,20.0));

	return;
}

simulated function Destroyed()
{
	StopTrail();

	return;
}

defaultproperties
{
     LightEffect=LE_QuadraticNonIncidence
     LightHue=28
     LightBrightness=255.000000
     LightRadius=6.000000
     bDynamicLight=True
     bOnlyDrawIfAttached=False
     bNetInitialRotation=True
     Mesh=SkeletalMesh'JetPackMesh.JetPackMesh'
     DrawScale=0.150000
     AmbientGlow=96
     SoundVolume=255
     SoundRadius=50.000000
     ForceType=FT_DragAlong
     ForceRadius=100.000000
     ForceScale=5.000000
}
