//---------------//
// JetpackPickup //
//---------------//

class JetpackPickup extends Pickup;

var(Jetpack) bool bNeedFuel;
var(Jetpack) bool bAutoRefuel;
var(Jetpack) float Fuel;

function Inventory SpawnCopy(Pawn Other)
{
	local Inventory inv;

	inv = super.SpawnCopy(Other);

	JetpackInv(inv).bNeedFuel = bNeedFuel;
	JetpackInv(inv).bAutoRefuel = bAutoRefuel;
	JetpackInv(inv).MaxFuel = Fuel;
	JetpackInv(inv).Fuel = Fuel;

	return inv;
}

defaultproperties
{
     bNeedFuel=True
     bAutoRefuel=True
     Fuel=5.000000
     InventoryType=Class'jetpack.JetpackInv'
     RespawnTime=10.000000
     PickupMessage="You got a Jetpack"
     CullDistance=6500.000000
     Physics=PHYS_Rotating
     Mesh=SkeletalMesh'JetPackMesh.JetPackMesh'
     DrawScale=0.150000
     AmbientGlow=128
     CollisionRadius=36.000000
     CollisionHeight=30.000000
     RotationRate=(Yaw=32768)
     MessageClass=Class'UnrealGame.PickupMessagePlus'
}
