//----------------//
// JetpackMutator //
//----------------//

class JetpackMutator extends Mutator;

var config bool bNeedFuel;
var config bool bAutoFuel;
var config float MaxFuel;

function bool AlwaysKeep(Actor Other)
{
	if (Other.IsA('JetpackInv')) return True;
	else return Super.AlwaysKeep(Other);
}

function ModifyPlayer(Pawn Other)
{
	local JetpackInv JPI;

	JPI = Spawn(class'JetpackInv', Other);
	JPI.bNeedFuel = bNeedFuel;
	JPI.bAutoRefuel = bAutoFuel;
	JPI.MaxFuel = MaxFuel;
	JPI.Fuel = MaxFuel;
	Other.AddInventory(JPI);
	JPI.AttachToPawn(Other);

	Super.ModifyPlayer(Other);

	return;
}

static function FillPlayInfo(PlayInfo PlayInfo)
{
	Super.FillPlayInfo(PlayInfo);

	PlayInfo.AddSetting(default.RulesGroup, "bNeedFuel", "Jetpack require fuel", 0, 1, "Check");
	PlayInfo.AddSetting(default.RulesGroup, "bAutoFuel", "Jetpack refuels itself automatically", 0, 1, "Check");
	PlayInfo.AddSetting(default.RulesGroup, "MaxFuel", "Amount of fuel jetpack has", 0, 1, "Text", "5.0;1.0:3600.0");

	return;
}

defaultproperties
{
     bAutoFuel=True
     MaxFuel=5.000000
     bAddToServerPackages=True
     FriendlyName="Jetpack"
     Description="Gives players a jetpack to fly around with."
}
