//-------------------//
// JetpackPickupBase //
//-------------------//

class JetpackPickupBase extends xPickupBase;

var(Jetpack) bool bNeedFuel;
var(Jetpack) bool bAutoRefuel;
var(Jetpack) float Fuel;

function SpawnPickup()
{
	if( PowerUp == None )
		return;

	myPickUp = Spawn(PowerUp,,,Location + SpawnHeight * vect(0,0,1), Powerup.default.Rotation);

	if (myPickUp != None)
	{
		myPickUp.PickUpBase = self;
		myPickup.Event = event;
	}

	if (myMarker != None)
	{
		myMarker.markedItem = myPickUp;
		myMarker.ExtraCost = ExtraPathCost;
		if (myPickUp != None)
		    myPickup.MyMarker = MyMarker;
	}
	else log("No marker for "$self);

	JetpackPickup(myPickUp).bNeedFuel = bNeedFuel;
	JetpackPickup(myPickUp).bAutoRefuel = bAutoRefuel;
	JetpackPickup(myPickUp).Fuel = Fuel;

	return;
}

defaultproperties
{
     bNeedFuel=True
     bAutoRefuel=True
     Fuel=5.000000
     PowerUp=Class'jetpack.JetpackPickup'
     SpawnHeight=60.000000
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'XGame_rc.ShieldChargerMesh'
     Texture=None
     DrawScale=0.800000
}
