//------------//
// JetpackInv //
//------------//

class JetpackInv extends Inventory;

var bool bOn;
var bool bMoveSet;
var bool bFindPlayer;
var bool bReadyToWork;
var bool bInVehicle;
var bool bNeedFuel;
var bool bAutoRefuel;
var bool bRepFuel;
var float Fuel, MaxFuel, RepFuel;
var config float Thrust;
var float ThrustWarmupTime;
var float ThrustWarmupStart;
var float MoveX, MoveY;
var float DeltaMoveX, DeltaMoveY;
var float MaxMove;
var float MoveRate;
var float CenterRate;
var float JetDistance;
var Pawn AttachedPawn;
var PlayerController AttachedPlayer;

replication
{
	reliable if (Role == ROLE_Authority)
		bOn, bNeedFuel, bAutoRefuel, Fuel, MaxFuel,
		bRepFuel, RepFuel, MoveX, MoveY, DeltaMoveX, DeltaMoveY,
		AttachedPawn, AttachedPlayer, SetClientJetpack;

	reliable if (Role < ROLE_Authority)
		ToggleJetpack, ServerJetpackMove;
}

function PickupFunction(Pawn Other)
{
	AttachToPawn(Other);

	return;
}

function AttachToPawn(Pawn P)
{
	if (P == None) return;

	AttachedPawn = P;
	if (P.Controller.IsA('PlayerController'))
	{
		AttachedPlayer = PlayerController(P.Controller);
		SetClientJetpack(False, False);
	}
	else AttachedPlayer = None;

	return;
}

simulated function DetachFromPawn(Pawn P)
{
	if (ThirdPersonActor != None)
	{
		ThirdPersonActor.SetLocation(P.Location);
		ThirdPersonActor.SetBase(None);
		ThirdPersonActor = None;
	}

	AttachedPawn = None;

	return;
}

simulated function AttachedPawnDied()
{
	local Actor a;

	a = ThirdPersonActor;
	if (AttachedPawn != None) AttachedPawn.AirControl = AttachedPawn.default.AirControl;
	DetachFromPawn(AttachedPawn);
	bOn = False;
	if (AttachedPlayer != None) SetClientJetpack(False, True);
	Pawn(Owner).DeleteInventory(Self);
	if (a != None) JetpackInvAttachment(a).SetDying();
	a = None;

	return;
}

function ToggleJetpack(bool b)
{
	if (!b)
	{
		bOn = False;
		if (AttachedPlayer != None) SetClientJetpack(bOn, False);
		ThrustWarmupTime = default.ThrustWarmupTime;
		MoveX = 0.0;
		MoveY = 0.0;
		if (ThirdPersonActor != None) JetpackInvAttachment(ThirdPersonActor).StopTrail();
		if (AttachedPawn != None) AttachedPawn.AirControl = AttachedPawn.default.AirControl;
	}
	else if (!bInVehicle)
	{
		bOn = True;
		if (AttachedPlayer != None) SetClientJetpack(bOn, False);
		if (ThirdPersonActor != None) JetpackInvAttachment(ThirdPersonActor).StartTrail();
		if (AttachedPawn != None) AttachedPawn.AirControl = 0.0;
	}

	return;
}

function ServerJetpackMove(float dX, float dY)
{
	DeltaMoveX = dX;
	DeltaMoveY = dY;

	return;
}

simulated function JetpackMove(float dX, float dY)
{
	DeltaMoveX = dX;
	DeltaMoveY = dY;
	ServerJetpackMove(dX, dY);

	return;
}

simulated function SetClientJetpack(bool bO, bool bD)
{
	local int i;
	local bool b;

	bOn = bO;

	if (AttachedPlayer.Player != None)
	{
		for (i = 0; i < AttachedPlayer.Player.LocalInteractions.Length; i++)
		{
			if (AttachedPlayer.Player.LocalInteractions[i].IsA('JetpackInteraction'))
			{
				if (!bD) JetpackInteraction(AttachedPlayer.Player.LocalInteractions[i]).TrapJetpackMovement(Self, bOn);
				else JetpackInteraction(AttachedPlayer.Player.LocalInteractions[i]).TrapJetpackMovement(None, bOn);
				b = true;
				break;
			}
		}

		if (!b && (AttachedPlayer.Player.InteractionMaster != none))
		{
			AttachedPlayer.Player.InteractionMaster.AddInteraction("Jetpack.JetpackInteraction", AttachedPlayer.Player);
			for (i = 0; i < AttachedPlayer.Player.LocalInteractions.Length; i++)
			{
				if (AttachedPlayer.Player.LocalInteractions[i].IsA('JetpackInteraction'))
				{
					if (!bD) JetpackInteraction(AttachedPlayer.Player.LocalInteractions[i]).TrapJetpackMovement(Self, bOn);
					else JetpackInteraction(AttachedPlayer.Player.LocalInteractions[i]).TrapJetpackMovement(None, bOn);
					break;
				}
			}
		}
	}

	// set effects and junk
	if (bOn && !bInVehicle && (ThirdPersonActor != None)) JetpackInvAttachment(ThirdPersonActor).StartTrail();
	else if (ThirdPersonActor != None) JetpackInvAttachment(ThirdPersonActor).StopTrail();

	return;
}

simulated function Tick(float DeltaTime)
{
	local vector ThrustVec, X, Y, Z;

	if (!bReadyToWork && (AttachedPawn == none)) return;
	else if (!bReadyToWork)
	{
		bReadyToWork = true;
		if (ThirdPersonActor == None)
		{
			ThirdPersonActor = Spawn(AttachmentClass, AttachedPawn,,, AttachedPawn.Rotation);
			InventoryAttachment(ThirdPersonActor).InitFor(self);
			ThirdPersonActor.SetLocation(AttachedPawn.Location + vector(AttachedPawn.Rotation) * -20.0 + vect(0.0,0.0,2.0));
			ThirdPersonActor.SetBase(AttachedPawn);
		}
	}

	if ((AttachedPlayer != none) && (AttachedPlayer.Pawn != AttachedPawn) && !bInVehicle)
	{
		if (ThirdPersonActor != none) ThirdPersonActor.bHidden = true;
		bInVehicle = true;
	}
	else if ((AttachedPlayer != none) && (AttachedPlayer.Pawn == AttachedPawn) && bInVehicle)
	{
		if (ThirdPersonActor != none) ThirdPersonActor.bHidden = false;
		bInVehicle = false;
	}

	if (AttachedPawn == none)
	{
		AttachedPawnDied();

		return;
	}

	if ((AttachedPawn != None) && AttachedPawn.bDeleteMe)
	{
		AttachedPawnDied();

		return;
	}
	else if ((Pawn(Owner) != None) && Pawn(Owner).bDeleteMe)
	{
		AttachedPawnDied();

		return;
	}

	if (AttachedPawn.Health <= 0)
	{
		AttachedPawnDied();

		return;
	}
	else if (Pawn(Owner).Health <= 0)
	{
		AttachedPawnDied();

		return;
	}

	if (bFindPlayer && (Level.GetLocalPlayerController() != none))
	{
		if (Level.GetLocalPlayerController().Pawn == AttachedPawn)
		{
			SetClientJetpack(false, false);
			bFindPlayer = False;
		}
	}

	// we have the real local player, use the input vars

	if ((DeltaMoveX != 0.0) && bOn)
	{
		if ((DeltaMoveX < 0.0) && (MoveX > -MaxMove))
		{
			MoveX -= MoveRate * DeltaTime;
			if (MoveX < -MaxMove) MoveX = -MaxMove;
		}
		else if ((DeltaMoveX > 0.0) && (MoveX < MaxMove))
		{
			MoveX += MoveRate * DeltaTime;
			if (MoveX > MaxMove) MoveX = MaxMove;
		}
	}
	// make the jetpack move to center itself
	else
	{
		if ((MoveX > 0.0) && ((MoveX - CenterRate * DeltaTime) < 0.0)) MoveX = 0.0;
		else if (MoveX > 0.0) MoveX -= CenterRate * DeltaTime;
		else if ((MoveX < 0.0) && ((MoveX + CenterRate * DeltaTime) > 0.0)) MoveX = 0.0;
		else if (MoveX < 0.0) MoveX += CenterRate * DeltaTime;
	}

	if ((DeltaMoveY != 0.0) && bOn)
	{
		if ((DeltaMoveY < 0.0) && (MoveY > -MaxMove))
		{
			MoveY -= MoveRate * DeltaTime;
			if (MoveY < -MaxMove) MoveY = -MaxMove;
		}
		else if ((DeltaMoveY > 0.0) && (MoveY < MaxMove))
		{
			MoveY += MoveRate * DeltaTime;
			if (MoveY > MaxMove) MoveY = MaxMove;
		}
	}
	// make the jetpack move to center itself
	else
	{
		if ((MoveY > 0.0) && ((MoveY - CenterRate * DeltaTime) < 0.0)) MoveY = 0.0;
		else if (MoveY > 0.0) MoveY -= CenterRate * DeltaTime;
		else if ((MoveY < 0.0) && ((MoveY + CenterRate * DeltaTime) > 0.0)) MoveY = 0.0;
		else if (MoveY < 0.0) MoveY += CenterRate * DeltaTime;
	}

	if (bRepFuel && (RepFuel > Fuel))
	{
		if (RepFuel > MaxFuel) RepFuel = MaxFuel;
		if (RepFuel > Fuel) Fuel += DeltaTime * 2.0;
		if (RepFuel <= Fuel)
		{
			Fuel = RepFuel;
			bRepFuel = false;
		}
	}

	if (bOn && bNeedFuel && (Fuel > 0.0))
	{
		if (bRepFuel)
		{
			RepFuel -= DeltaTime;
			if (RepFuel <= Fuel)
			{
				Fuel = RepFuel;
				bRepFuel = false;
			}
		}
		else Fuel -= DeltaTime;
		if (Fuel <= 0.0)
		{
			Fuel = 0.0;
			ToggleJetpack(false);

			return;
		}
	}
	else if (!bOn && bAutoRefuel && (Fuel < MaxFuel))
	{
		Fuel += DeltaTime;
		if (Fuel >= MaxFuel) Fuel = MaxFuel;
	}

	// manage thrust increase and effects
	if (bOn)
	{
		JetDistance += VSize(AttachedPawn.Velocity) * DeltaTime;

		if (AttachedPawn.Physics != PHYS_Falling) AttachedPawn.SetPhysics(PHYS_Falling);

		if (ThrustWarmupTime > 0.0)
		{
			ThrustWarmupTime -= DeltaTime;
			if (ThrustWarmupTime < 0.0)
			{
				ThrustWarmupTime = 0.0;
				Thrust = default.Thrust;
			}
			else
			{
				Thrust = (default.ThrustWarmupTime - ThrustWarmupTime) / default.ThrustWarmupTime * (default.Thrust - ThrustWarmupStart) + ThrustWarmupStart;
			}
		}

		GetAxes(AttachedPawn.Rotation, X, Y, Z);
		ThrustVec = Normal(X * MoveX + Y * MoveY + Z * MaxMove) * Thrust * DeltaTime;

		AttachedPawn.AddVelocity(ThrustVec);
	}

	return;
}

function Destroyed()
{
	if (AttachedPawn != none) AttachedPawnDied();

	return;
}

defaultproperties
{
     bFindPlayer=True
     Thrust=3000.000000
     ThrustWarmupTime=2.000000
     ThrustWarmupStart=1000.000000
     MaxMove=500.000000
     MoveRate=200.000000
     CenterRate=200.000000
     AttachmentClass=Class'jetpack.JetpackInvAttachment'
     ItemName="Jetpack"
     bNetNotify=True
}
