//--------------------//
// JetpackInteraction //
//--------------------//

class JetpackInteraction extends Interaction;

#exec OBJ LOAD FILE=JetpackTextures.utx name=JetpackTextures

var JetpackInv JI;
var bool bTrapMovement;
var bool bJump;
var config float JumpHoldLimit;
var float FirstJumpTime;
var float DoubleJumpTime;
var float HeldX, HeldY;
var float CurDistance, FarthestDistance;
var float HUDPositionX, HUDPositionY;
var int FuelNeedleRotLimit;

simulated function bool KeyEvent(out EInputKey Key, out EInputAction Action, FLOAT Delta)
{
	local string KeyName, KeyBind;
	local bool b;

	if (JI == none) return false;
	if (JI.bInVehicle) return false;

	KeyName = ViewportOwner.Actor.ConsoleCommand("keyname "$int(Key));
	KeyBind = ViewportOwner.Actor.ConsoleCommand("keybinding "$KeyName);

	if (KeyBind ~= "Jump")
	{
		if ((Action == IST_Press) && !bJump)
		{
			FirstJumpTime = ViewportOwner.Actor.Level.TimeSeconds;

			/*if (FirstJumpTime == 0.0) FirstJumpTime = ViewportOwner.Actor.Level.TimeSeconds;
			else if (ViewportOwner.Actor.Level.TimeSeconds > FirstJumpTime + DoubleJumpTime)
			{
				FirstJumpTime = ViewportOwner.Actor.Level.TimeSeconds;
			}
			else
			{
				FirstJumpTime = 0.0;
				JI.ToggleJetpack(true);
			}*/

			bJump = true;
		}
/*		else if ((Action == IST_Hold) && bJump)
		{
			Log("we're here");
			if (!JI.bOn && ((ViewportOwner.Actor.Level.TimeSeconds - FirstJumpTime) > JumpHoldLimit))
			{
				Log("Finally here too");
				JI.ToggleJetpack(True);
			}
		}*/
		else if ((Action == IST_Release) && bJump)
		{
			JI.ToggleJetpack(False);
			bJump = False;
		}
	}
	else if (KeyBind ~= "MoveForward")
	{
		if ((Action == IST_Press) && (HeldX != 1.0))
		{
			HeldX = 1.0;
			if (bTrapMovement) b = True;
		}
		else if (Action == IST_Release)
		{
			HeldX = 0.0;
			if (bTrapMovement) b = True;
		}
	}
	else if (KeyBind ~= "MoveBackward")
	{
		if ((Action == IST_Press) && (HeldX != -1.0))
		{
			HeldX = -1.0;
			if (bTrapMovement) b = True;
		}
		else if (Action == IST_Release)
		{
			HeldX = 0.0;
			if (bTrapMovement) b = True;
		}
	}
	else if (KeyBind ~= "StrafeLeft")
	{
		if ((Action == IST_Press) && (HeldY != -1.0))
		{
			HeldY = -1.0;
			if (bTrapMovement) b = True;
		}
		else if (Action == IST_Release)
		{
			HeldY = 0.0;
			if (bTrapMovement) b = True;
		}
	}
	else if (KeyBind ~= "StrafeRight")
	{
		if ((Action == IST_Press) && (HeldY != 1.0))
		{
			HeldY = 1.0;
			if (bTrapMovement) b = True;
		}
		else if (Action == IST_Release)
		{
			HeldY = 0.0;
			if (bTrapMovement) b = True;
		}
	}

	if (b) JI.JetpackMove(HeldX, HeldY);

	return false;
}

simulated function TrapJetpackMovement(JetpackInv tJI, bool b)
{
	JI = tJI;
	bTrapMovement = b;
	if (JI != None) JI.JetpackMove(HeldX, HeldY);
	else if (CurDistance > FarthestDistance) FarthestDistance = CurDistance;

	CurDistance = 0.0;

	return;
}

simulated function HandleJI()
{
	if ((JI != None) && (ViewportOwner.Actor != None) && (ViewportOwner.Actor.Pawn != None) && (ViewportOwner.Actor.Pawn == JI.Owner) && (ViewportOwner.Actor.Pawn.FindInventoryType(class'JetpackInv') == None))
	{
		TrapJetpackMovement(None, false);
	}
	else if ((JI == none) && bTrapMovement && (ViewportOwner.Actor != none) && (ViewportOwner.Actor.Pawn != none) && (ViewportOwner.Actor.Pawn.FindInventoryType(class'JetpackInv') != none))
	{
		JI = JetpackInv(ViewportOwner.Actor.Pawn.FindInventoryType(class'JetpackInv'));
		TrapJetpackMovement(JI, true);
	}

	if (JI != none) CurDistance = JI.JetDistance;

	return;
}

simulated function Tick(float DeltaTime)
{
	HandleJI();

	if (bJump && (JI != None) && !JI.bOn && ((ViewportOwner.Actor.Level.TimeSeconds - FirstJumpTime) > JumpHoldLimit))
		JI.ToggleJetpack(True);

	return;
}

simulated function Material MatFromNum(int i)
{
	local Material m;

	if (i == -1) m = texture'JetpackTextures.number9';
	if (i == 0) m = texture'JetpackTextures.number0';
	if (i == 1) m = texture'JetpackTextures.number1';
	if (i == 2) m = texture'JetpackTextures.number2';
	if (i == 3) m = texture'JetpackTextures.number3';
	if (i == 4) m = texture'JetpackTextures.number4';
	if (i == 5) m = texture'JetpackTextures.number5';
	if (i == 6) m = texture'JetpackTextures.number6';
	if (i == 7) m = texture'JetpackTextures.number7';
	if (i == 8) m = texture'JetpackTextures.number8';
	if (i == 9) m = texture'JetpackTextures.number9';
	if (i == 10) m = texture'JetpackTextures.number0';

	return m;
}

simulated function PostRender(Canvas C)
{
	local float ResScaleX, ResScaleY, x, y;
	local float f;
	local int d, i, j;
	local int dist[8];
	local Material m;

	if (JI == none) return;

	ResScaleX = C.SizeX / 1024.0;
	ResScaleY = C.SizeY / 768.0;

	C.SetDrawColor(255,255,255);
	C.Style = JI.ERenderStyle.STY_Translucent;

	// render gauge backdrop
	m = Texture'JetpackTextures.hudfuelgauge';
	C.SetPos(C.SizeX * HUDPositionX * ResScaleX, C.SizeY * HUDPositionY * ResScaleY);
	C.DrawTileScaled(m, ResScaleX, ResScaleY);

	// render gauge backdrop
	m = Material'JetpackTextures.fuelgaugeneedlerotator';
	C.SetPos(C.SizeX * HUDPositionX * ResScaleX, C.SizeY * HUDPositionY * ResScaleY);
	if (JI.bNeedFuel) TexRotator(m).Rotation.Yaw = int(FuelNeedleRotLimit * -2.0 * JI.Fuel / JI.MaxFuel) + FuelNeedleRotLimit;
	else TexRotator(m).Rotation.Yaw = FuelNeedleRotLimit * -1;
	C.DrawTileScaled(m, ResScaleX, ResScaleY);

	// render distance travelled
	C.Style = JI.ERenderStyle.STY_Normal;

	d = int(CurDistance / 10);
	for (i = 7; i >= 0; i--)
	{
		dist[i] = d % 10;
		d /= 10;
	}

	x = (C.SizeX * HUDPositionX + m.MaterialUSize() * 0.5 + 94.0 * 0.5) * ResScaleX;
	y = (C.SizeY * HUDPositionY + m.MaterialVSize() * 0.75) * ResScaleY;
	C.SetPos(x, y);

	for (i = 6; i >= 0; i--)
	{
		f = 0.0;
		if ((i < 6) && (dist[i + 1] == 9))
		{
			for (j = 7; j > (i + 1); j--) f += dist[j] * (0.1 ** (j - (i + 1)));
		}
		else if (i == 6)
		{
			for (j = 7; j > i; j--) f += dist[j] * (0.1 ** (j - i));
		}
		m = MatFromNum(dist[i]);
		x -= (m.MaterialUSize() - 1) * ResScaleX;
		C.SetPos(x, y);
		C.DrawTile(m, m.MaterialUSize() - 1, m.MaterialVSize() - f * m.MaterialVSize(), 0, f * m.MaterialVSize(), m.MaterialUSize() - 1, m.MaterialVSize() - f * m.MaterialVSize());
		m = MatFromNum(dist[i] + 1);
		C.SetPos(x, y + m.MaterialVSize() - f * m.MaterialVSize());
		C.DrawTile(m, m.MaterialUSize() - 1, f * m.MaterialVSize(), 0, 0, m.MaterialUSize() - 1, f * m.MaterialVSize());
		if (i == 6)
		{
			m = texture'JetpackTextures.numberDot';
			x -= m.MaterialUSize() * ResScaleX;
			C.SetPos(x, y);
			C.DrawTileScaled(m, ResScaleX, ResScaleY);
		}
	}

	return;
}

simulated function NotifyLevelChange()
{
	JI = None;
	bActive = False;
	Master.RemoveInteraction(Self);

	return;
}

defaultproperties
{
     JumpHoldLimit=0.250000
     DoubleJumpTime=0.250000
     HUDPositionX=0.004880
     HUDPositionY=0.416660
     FuelNeedleRotLimit=7300
     bVisible=True
     bRequiresTick=True
}
