//-------------------//
// JetpackFuelPickup //
//-------------------//

class JetpackFuelPickup extends Pickup;

#exec OBJ LOAD FILE=JetpackSM.usx name=JetpackSM

var(Jetpack) enum EJetpackFuel
{
	JETPACK_SetFuel,
	JETPACK_RandomFuel
} FuelType;
var(Jetpack) Range RandomFuelRange;
var(Jetpack) float FuelPercent;
var float Fuel;

replication
{
	reliable if (Role == ROLE_Authority)
		FuelPercent;
}

function PostBeginPlay()
{
	super.PostBeginPlay();

	if (FuelType == JETPACK_RandomFuel)
	{
		RandomFuelRange.Min = FClamp(RandomFuelRange.Min, 0.0, 1.0);
		RandomFuelRange.Max = FClamp(RandomFuelRange.Max, 0.0, 1.0);

		Fuel = FRand() * (RandomFuelRange.Max - RandomFuelRange.Min) + RandomFuelRange.Min;
	}
	else Fuel = FuelPercent;

	SetFuel();

	return;
}

simulated function PostNetReceive()
{
	super.PostNetReceive();

	if (Fuel > 0.0) SetFuel();

	return;
}

simulated function SetFuel()
{
	SetDrawScale(Fuel + 1.0);

	return;
}

function Inventory SpawnCopy(Pawn Other)
{
	local JetpackInv JI;

	JI = JetpackInv(Other.FindInventoryType(class'JetpackInv'));
	if (JI != none)
	{
		JI.bRepFuel = True;
		JI.RepFuel += JI.MaxFuel * Fuel;
	}

	return none;
}

defaultproperties
{
     RandomFuelRange=(Max=1.000000)
     FuelPercent=0.500000
     PickupMessage="Refueled your Jetpack"
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'JetpackSM.FuelPickup'
     Physics=PHYS_Rotating
     bNetNotify=True
     MessageClass=Class'UnrealGame.PickupMessagePlus'
}
