//-------------------//
// JetpackDeathTrail //
//-------------------//

class JetpackDeathTrail extends Effects;

var float LifeTime, OrigLifeTime;
var JetpackDeathTrailSmoke JDTS;

simulated function PostBeginPlay()
{
	LifeTime = frand() * 1.0 + 1.0;
	OrigLifeTime = LifeTime;
	JDTS = Spawn(class'JetpackDeathTrailSmoke', Self);
	JDTS.mLifeRange[0] = LifeTime;
    JDTS.mLifeRange[1] = LifeTime;
    JDTS.mSizeRange[0] = 200.0;
    JDTS.mSizeRange[1] = 200.0;
    Velocity = vector(Rotation) * (frand() * 1000.0 + 500.0);

	return;
}

simulated function Tick(float DeltaTime)
{
	LifeTime -= DeltaTime;
	if (LifeTime <= 0.0)
	{
		// kill the trail
		JDTS.LifeSpan = 1.0;
		Destroy();
	}
	else
	{
		// modify trail based
		JDTS.mLifeRange[0] = LifeTime;
		JDTS.mLifeRange[1] = LifeTime;
		JDTS.mSizeRange[0] = 200.0 * LifeTime / OrigLifeTime;
		JDTS.mSizeRange[1] = 200.0 * LifeTime / OrigLifeTime;
	}

	return;
}

simulated function Landed(vector HitNormal)
{
	Destroy();
}

simulated function HitWall(vector HitNormal, Actor HitWall)
{
	Destroy();
}

defaultproperties
{
     DrawType=DT_None
     bHidden=True
     Physics=PHYS_Falling
     bGameRelevant=False
}
