//-------------------//
// JetpackDeadActor //
//-------------------//

class JetpackDeadActor extends Actor;

/*

	This class is meant to be pure effect - a jetpack flying around out of control

*/

#exec OBJ LOAD FILE=WeaponSounds.uax NAME=WeaponSounds

var	Emitter ST1, ST2;
var bool bFly;
var float LifeTime;
var int EDCount;

simulated function StartTrail()
{
	local coords c;
	if (Level.NetMode != NM_DedicatedServer)
	{
		if (ST1 == None)
		{
			c = GetBoneCoords('L_EngineExhaust');
			ST1 = Spawn(class'JetpackSmokeTrail', self,, c.Origin);
			ST1.SetBase(self);
		}
		if (ST2 == None)
		{
			c = GetBoneCoords('R_EngineExhaust');
			ST2 = Spawn(class'JetpackSmokeTrail', self,, c.Origin);
			ST2.SetBase(self);
		}
		LightType = LT_Steady;
		bDynamicLight = True;
		AmbientSound = Sound'WeaponSounds.redeemer_flight';
	}

	return;
}

simulated function StopTrail()
{
	if (Level.NetMode != NM_DedicatedServer)
	{
		if (ST1 != None)
		{
			ST1.Kill();
			ST1 = None;
		}
		if (ST2 != none)
		{
			ST2.Kill();
			ST2 = none;
		}
		LightType = LT_None;
		bDynamicLight = False;
		AmbientSound = None;
	}

	return;
}

simulated function Tick(float DeltaTime)
{
	if (bFly)
	{
		DesiredRotation += RotationRate * DeltaTime;
		Velocity += vector(Rotation) * 500 * DeltaTime;
		if (VSize(Velocity) > 2000.0) Velocity = Normal(Velocity) * 2000.0;
	}
	else if (DesiredRotation != Rotation)
	{
		DesiredRotation = Rotation;
		bRotateToDesired = False;
	}

	if (LifeTime > 0.0)
	{
		LifeTime -= DeltaTime;
		if (LifeTime < 0.0)
		{
			LifeTime = 0.0;
			GotoState('ExplodyDeathorama');
		}
	}

	return;
}

simulated function Bump(Actor Other)
{
	HitWall(Normal(Location - Other.Location), Other);

	return;
}

simulated function Landed(vector HitNormal)
{
	HitWall(HitNormal, None);

	return;
}

simulated function HitWall(vector HitNormal, actor HitWall)
{
	// we want to turn away from whatever we hit

	// if HitNormal points with our Rotation, ignore it since we'll be moving away anyways
	if ((HitNormal dot vector(Rotation)) < 0.0)
	{
		Velocity = MirrorVectorByNormal(Velocity, HitNormal);
	}
	else
	{
		// find the angle of impact and direct us away at that same angle
		DesiredRotation = rotator(MirrorVectorByNormal(vector(Rotation), HitNormal));
		Velocity = MirrorVectorByNormal(Velocity, HitNormal);
	}

	return;
}

// we use this state to make the explodirific death
state ExplodyDeathorama
{
	simulated function BeginState()
	{
		SmallExplosion();
		SetTimer(frand() * 1.0, False);
	}

	simulated function Timer()
	{
		local int i;
		local vector v;

		SmallExplosion();
		if (++EDCount >= 5)
		{
			bFly = False;
			StopTrail();

			for (i = 0; i < 3; i++)
			{
				v = VRand();
				v.Z += 1.0;
				Spawn(class'JetpackDeathTrail',,, Location + v * 10.0, rotator(v));
			}

			Destroy();
		}
		else SetTimer(frand() / EDCount, False);

		return;
	}
}

simulated function SmallExplosion()
{
	Spawn(class'SmallRedeemerExplosion',,,, RotRand());
	if (rand(2) == 0) PlaySound(Sound'WeaponSounds.BaseImpactAndExplosions.BExplosion1',, 127,, 75);
	else PlaySound(Sound'WeaponSounds.BaseImpactAndExplosions.BExplosion2',, 127,, 75);

	return;
}

defaultproperties
{
     bFly=True
     Lifetime=5.000000
     LightEffect=LE_QuadraticNonIncidence
     LightHue=28
     LightBrightness=255.000000
     LightRadius=6.000000
     DrawType=DT_Mesh
     bDynamicLight=True
     bNetInitialRotation=True
     Physics=PHYS_Projectile
     RemoteRole=ROLE_None
     Mesh=SkeletalMesh'JetPackMesh.JetPackMesh'
     DrawScale=0.150000
     AmbientGlow=96
     SoundVolume=255
     SoundRadius=100.000000
     CollisionRadius=24.000000
     CollisionHeight=12.000000
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bBlockKarma=True
     bRotateToDesired=True
     ForceType=FT_DragAlong
     ForceRadius=100.000000
     ForceScale=5.000000
}
