// ============================================================================
// Game Logger support for JB-speecific scoring stats
//
// Copyright 2005 by Michael "_Lynx" Sokolkov <unreal-pz@narod.ru>
// Date      : 03.01.2005
// Revision  : 1
//
// Finds the JBPLayerTag for the given PlayerReplicationInfo and writes down
// ScorePartialAttack, ScorePartialDefence and ScorePartialRelease from it
// ============================================================================
class GameLoggerJBStats extends GameLoggerExtraStatsPlugin;

function GimmeStats(PlayerReplicationInfo PRIs, GameReplicationInfo GRI, string TDstyle){
	local JBTagPlayer thisPlayersTag;

	// checking to avoid calling if there's no JB
	if (Level.Game.GameName != "Jailbreak"){
		Log("Game is not jailbreak");
		return;

	}
	// Getting JBPlayerTagForOurPRI
	thisPlayersTag = Class'JBTagPlayer'.Static.FindFor(PRIs);

	if (thisPlayersTag != None ){
		//empty string to separate these stats from standard ones
	  LogF("<tr>");
		LogF("	<td colspan=2 width=100% align=center>&nbsp</td>");
		LogF("</tr>");
		LogF("<tr>");
		LogF("	<td colspan=2 width=100% align=center><strong>Jaibreak Stats</strong></td>");
		LogF("</tr>");
	  Logf("<tr>");
	  Logf("	<td width=200 class="$TDstyle$">Attack score:</td><td class="$TDStyle$" width=\"*\" align=center>"$thisPlayersTag.ScorePartialAttack$"</td>");
	  Logf("</tr>");
	  Logf("<tr>");
	  Logf("	<td width=200 class="$TDstyle$">Defence Score:</td><td class="$TDStyle$" width=\"*\" align=center>"$thisPlayersTag.ScorePartialDefense$"</td>");
	  Logf("</tr>");
	  Logf("<tr>");
	  Logf("	<td width=200>Releases:</td><td width=\"*\" align=center>"$thisPlayersTag.ScorePartialRelease$"</td>");
	  Logf("</tr>");
	}
	else{
		Log("JBPlayerTag wasn't found");
	}
}

DefaultProperties
{
  FriendlyName="GameLogger JB stats plugin"
  Description="Retrives specific JB players' stats"
  Author="Michael \"_Lynx\" Sokolkov"
  version="1.0a"
}
