//-----------------------------------------------------------
//  Game Logger Extra Stats Plugin
//
// Base class for plugins containing names of additional
// stats
// This is added for simplicity of adding support for new
// stats and also make the main mutator independent
// from the packages containing this damagetypes.
//
// I strongly recommend using the "GameLogger" prefix for
// your package name
//
//-----------------------------------------------------------
// Suggestions for using:
//
// Create a GameRules actor which will collect and log the
// stats for you. Later I will add a chained list of stats
// actors, which will allow you to collect stats provided via
// default GameStats logger and output them into GameLogger's
// log.
//
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2005
//
// if you want to use this code for your own purposes (i.e.
// your own project, I don't mean extensions for GameLogger)
// mail me first: senninha_r@mail.ru
//-----------------------------------------------------------
class GameLoggerExtraStatsPlugin extends Gameloggerplugin
  abstract
  config(GameLogger);

// ============================================================================
// GimmeStats
// Called for each time the wrapper writes info about another player
//
// Note that the strings will be pasted after the default
// player stats, in the table and your code should either be in one, double
// sized table cell:
// <tr>
//   <td width="100%" colspan=2>
//     Your Strings
//   </td>
// </tr>
//
// or it should just continue the table like the following example. Note the
// first two raws of the table - they're used to make stats more readable.
// Also note that "&nbsp;" is the first raw - it used to make cell take full
// width but remain empty. All raws that contain stats except the last one
// should use the style passed to function as TDstyle. It 'underlines' the cell
// making the table more readable.
// <tr>
//   <td width="100%" colspan=2>&nbsp;</td>
// </tr>
// <tr>
//   <td width="100%" colspan=2>
//     Your section name
//   </td>
// </tr>
// <tr>
//   <td class=TDstyle>Stats param1</td><td>Stats param1 value</td>
// </tr>
// <tr>
//   <td class=TDstyle>Stats param2</td><td>Stats param2 value</td>
// </tr>
// <tr>
//   <td>Stats param3</td><td>Stats param3 value</td>
// </tr>
// etc.
// Note also that that table has a fixed width of 800 pixels so if you'll choose
// the first variant, fon't exceed this.
// ============================================================================
function GimmeStats(PlayerReplicationInfo PRIs, GameReplicationInfo GRI, string TDstyle);

// Just workaround to avoid lots of typing.
function LogF(string LogString){
 baseLogger.Logf(LogString);
}

DefaultProperties
{
  FriendlyName="GameLogger extra stats plugin"
  Description=""
}
