//-----------------------------------------------------------
//  Game Logger Mutator
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2004
//  version 4.0RC
//-----------------------------------------------------------
// TODO: also, make a check, if the specified server address
//       is an empty string, and if so, remove the "<A HREF>"
// TODO: GUI frontend for configuring plugins;
//-----------------------------------------------------------
class MutGameLogger extends Mutator config(GameLogger);

var localized string MouseOverHints[32];           // Mouseover hints for items in traditional mutator menu
var localized string ItemNames[32];                // The configurable item names

var globalconfig string MyBlueTeamName;            // This will be the blue team name
var globalconfig string MyRedTeamName;             // This will be the red team name
var globalconfig string EGSLogFileName;            // The log filename mask
var globalconfig string serverIP;                  // IP of the server for the link

var globalconfig bool bDuelMatch;                  // If true, will use Team Names for player names in DM
var globalconfig bool bEGSUseColoredNames;         // Coloring names in team games
var globalconfig bool bEGSUseColoredTeamNames;     // colored team names
var globalconfig bool bEGSShowTeamScoreEvents;     // team scoring events
var globalconfig bool bEGSShowConnectsDisconnects; // players entering/leaving
var globalconfig bool bEGSReportWeaponPickups;     // weapons picking
var globalconfig bool bEGSReportGameEvents;        // game events (e.g. new round in Assault)
var globalconfig bool bEGSReportItemPickups;       // log items picking
var globalconfig bool bEGSShowSStatus;             // special status (Admin/Bot)
var globalconfig bool bEGSUseGraphics;             // Enables <IMG> tages in Logger
var globalconfig bool bEGSExportDetailedStats;     // enables export of awards/comos and other stuff.
var globalconfig bool bEnableWorldStatsLogging;    // support for UT2004 World ranking system
var globalconfig bool bEGSdetailedplayerStats;     // should the logger dump the stats on every player
var globalconfig bool bEGSLogTalks;                // if the players' chat will be logged
var globalconfig bool bEGSRandomBGcolor;           // Enable random selction of background color
var globalconfig bool bIgnoreWarmupEvents;				 // Ignore the events that are happening before the match starts
var globalconfig bool bDontLogKills;

var globalconfig int backgroundcolor;              // Current background ground color in BGColors array
var globalconfig int EGSPlayerScoreEventsMode;     // Current mode for logging players' score events
var globalconfig int EGSReportHeavyDamageMode;     // Current mode for logging heavy damage events
var globalconfig int HDamagethreshold;             // The damage threshold flag int;
var globalconfig int Priv;												 // The privileges required to modify GameLogger's settings via WebAdmin

// Temp. Later I'll add a frontend GUI like the one in BotMixer
var globalconfig array< class<GameLoggerExtraStatsPlugin> >    AvailableStatsPlugins;
var globalconfig array< class<GameLoggerReportPlugin> >        AvailableReportPlugins;
var globalconfig array< class<GameLoggerWeaponDamagePlugin> >  AvailableDamagetypePlugins;

// ================================================================
//  PreBeginPlay()
//
// Passing our settings to the main classes
// ================================================================
function PreBeginPlay(){
    Super.PreBeginPlay();
    class'EGameStats'.default.bShowConnectsDisconnects = bEGSShowConnectsDisconnects;
    class'EGameStats'.default.bUseColoredNames         = bEGSUseColoredNames;
    class'EGameStats'.default.bUseColoredTeamNames     = bEGSUseColoredTeamNames;
    class'EGameStats'.default.PlayerScoreEventsMode    = EGSPlayerScoreEventsMode;
    class'EGameStats'.default.bShowTeamScoreEvents     = bEGSShowTeamScoreEvents;
    class'EGameStats'.default.bLogWeaponsPicks         = bEGSReportWeaponPickups;
    class'EGameStats'.default.bLogOtherPicks           = bEGSReportItemPickups;
    class'EGameStats'.default.bReportGameEvents        = bEGSReportGameEvents;
    class'EGameStats'.default.bLogTalks                = bEGSLogTalks;
    class'EGameStats'.default.bShowSStatus             = bEGSShowSStatus;
    class'EGameStats'.default.LogFilename              = EGSLogFileName;
    class'EGameStats'.default.bDuelMode                = bDuelMatch;
    class'EgameStats'.default.HeavyDamageReportMode    = EGSReportHeavyDamageMode;
    class'EgameStats'.default.bWSLenabled              = bEnableWorldStatsLogging;
    class'EgameStats'.default.bExportDetailedStats     = bEGSdetailedplayerStats;
    class'EgameStats'.default.serverIP                 = ServerIP;
    class'EgameStats'.default.ReportPluginClasses      = AvailableReportPlugins;
    class'EgameStats'.default.ExtraStatsPluginClasses  = AvailableStatsPlugins;
    class'EgameStats'.default.DamageTypePluginClasses  = AvailableDamagetypePlugins;
    class'EgameStats'.default.bIgnoreWarmupEvents			 = bIgnoreWarmupEvents;
    class'EgameStats'.default.bDontLogKills						 = bDontLogKills;

    class'GameLoggerRules'.default.DamageThreshold = HDamagethreshold;

    // Saving the settings
    class'EgameStats'.SaveConfig();
    class'GameLoggerRules'.SaveConfig();

    // class'EgameStats'.default.bNumberNameMode = bEGSNumberNameMode; // obsolete?

    // An ugly hack for stupid function InitLogging in GameInfo:

    // If we're offline or it's a listen server we'll force the game
    // to spawn the logger
    if (Level.NetMode == NM_Standalone || Level.NetMode == NM_ListenServer)
      Level.Game.GameStats = spawn(class'EGameStats');

    // if it's a dedicated server this trick won't work - it'll crash the game
    // we'll just make the game load our class instead of default
    else if (Level.NetMode == NM_DedicatedServer)
      Level.Game.GameStatsClass = "GameLogger.EGameStats";
    else return;
}

static function FillPlayInfo(PlayInfo PlayInfo)
{
	if (default.Priv < 0 || default.Priv > 255){
	  default.Priv = 1;
	}
  PlayInfo.AddClass(default.Class);
  PlayInfo.AddSetting("GameLogger Teams",    				 "MyBlueTeamName",               default.ItemNames[0],  default.Priv, 1,  "Text", "40");
  PlayInfo.AddSetting("GameLogger Teams",            "MyRedTeamName",                default.ItemNames[1],  default.Priv, 30, "Text", "40");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSUseColoredNames",          default.ItemNames[2],  default.Priv, 3,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSUseColoredTeamNames",      default.ItemNames[3],  default.Priv, 4,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "EGSPlayerScoreEventsMode",     default.ItemNames[4],  default.Priv, 5,  "Select", "0;Never ;1;All but kills (default);2;All");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSShowTeamScoreEvents",      default.ItemNames[5],  default.Priv, 6,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSShowConnectsDisconnects",  default.ItemNames[6],  default.Priv, 7,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSReportWeaponPickups",      default.ItemNames[7],  default.Priv, 8,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSReportItemPickups",        default.ItemNames[8],  default.Priv, 9,  "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSReportGameEvents",         default.ItemNames[9],  default.Priv, 10, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSShowSStatus",              default.ItemNames[10], default.Priv, 11, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSLogTalks",                 default.ItemNames[11], default.Priv, 12, "Check");
  PlayInfo.AddSetting("GameLogger Log Properties",   "EGSLogFileName",               default.ItemNames[12], default.Priv, 13, "Text", "40");
  PlayInfo.AddSetting("GameLogger Log Properties",   "ServerIP",                     default.ItemNames[13], default.Priv, 14, "Text", "40");
  PlayInfo.AddSetting("GameLogger Settings",         "bDuelMatch",                   default.ItemNames[14], default.Priv, 15, "Check");
  PlayInfo.AddSetting("GameLogger Log Properties",   "backgroundcolor",              default.ItemNames[15], default.Priv, 16, "Select", "0;Light grey (default);1;Dark Slate grey;2;White;3;Midnight Blue;4;Sand;5;Black;6;Indigo;7;Plain Grey;8;Dark Blue;9;British Racing Green;10;Blood;11;McLaren Orange;12;UT2004 Blue;13;UT2004 Gold;14;OLStats Dark Grey");
  PlayInfo.AddSetting("GameLogger Log Properties",   "bEGSRandomBGcolor",            default.ItemNames[16], default.Priv, 15, "Check");
  PlayInfo.AddSetting("GameLogger Log Properties",   "bEGSUseGraphics",              default.ItemNames[17], default.Priv, 17, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEGSdetailedplayerStats",      default.ItemNames[18], default.Priv, 18, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "bEnableWorldStatsLogging",     default.ItemNames[19], default.Priv, 19, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "EGSReportHeavyDamageMode",     default.ItemNames[20], default.Priv, 20, "Select", "0;Never (default);1;Only if vicim survives;2;Always");
  PlayInfo.AddSetting("GameLogger Settings",         "HDamageThreshold",             default.ItemNames[21], default.Priv, 21, "Select", "0;65;1;70;2;75 (default);3;80;4;85;5;90");
  PlayInfo.AddSetting("GameLogger Plugins",          "AvailableStatsPlugins",        default.ItemNames[22], default.Priv, 22, "Text", "100",,True,True);
  PlayInfo.AddSetting("GameLogger Plugins",          "AvailableReportPlugins",       default.ItemNames[23], default.Priv, 23, "Text", "100",,True,True);
  PlayInfo.AddSetting("GameLogger Plugins",          "AvailableDamagetypePlugins",   default.ItemNames[24], default.Priv, 24, "Text",,,True,True);
  PlayInfo.AddSetting("GameLogger Settings",   			 "bIgnoreWarmupEvents",          default.ItemNames[25], default.Priv, 25, "Check");
  PlayInfo.AddSetting("GameLogger Settings",   			 "bDontLogKills",          			 default.ItemNames[26], default.Priv, 26, "Check");
  PlayInfo.AddSetting("GameLogger Settings",         "Priv",   											 default.ItemNames[27],  255, 				24, "Text", "3",,True,True);
  PlayInfo.PopClass();
  super.FillPlayInfo(PlayInfo);
}

static event string GetDescriptionText(string PropName)
{
  switch (PropName)
  {
    case "MyBlueTeamName":
      return default.MouseOverHints[0];
    case "MyRedTeamName":
      return default.MouseOverHints[1];
    case "bEGSUseColoredNames":
      return default.MouseOverHints[2];
    case "bEGSUseColoredTeamNames":
      return default.MouseOverHints[3];
    case "EGSPlayerScoreEventsMode":
      return default.MouseOverHints[4];
    case "bEGSShowTeamScoreEvents":
      return default.MouseOverHints[5];
    case "bEGSShowConnectsDisconnects":
      return default.MouseOverHints[6];
    case "bEGSReportWeaponPickups":
      return default.MouseOverHints[7];
    case "bEGSReportItemPickups":
      return default.MouseOverHints[8];
    case "bEGSReportGameEvents":
      return default.MouseOverHints[9];
    case "bEGSShowSStatus":
      return default.MouseOverHints[10];
    case "bEGSLogTalks":
      return default.MouseOverHints[11];
    case "EGSLogFileName":
      return default.MouseOverHints[12];
    case "ServerIP":
      return default.MouseOverHints[13];
    case "bDuelMatch":
      return default.MouseOverHints[14];
    case "backgroundcolor":
      return default.MouseOverHints[15];
    case "bEGSrandomBGcolor":
      return default.MouseOverHints[16];
    case "bEGSUseGraphics":
      return default.MouseOverHints[17];
    case "bEGSdetailedplayerStats":
      return default.MouseOverHints[18];
    case "bEnableWorldStatsLogging":
      return default.MouseOverHints[19];
    case "EGSReportHeavyDamageMode":
      return default.MouseOverHints[20];
    case "HDamageThreshold":
      return default.MouseOverHints[21];
    case "AvailableStatsPlugins":
      return default.MouseOverHints[22];
    case "AvailableReportPlugins":
      return default.MouseOverHints[23];
    case "AvailableDamagetypePlugins":
      return default.MouseOverHints[24];
    case "bIgnoreWarmupEvents":
      return default.MouseOverHints[25];
    case "bDontLogKills":
      return default.MouseOverHints[26];
    case "Priv":
      return default.MouseOverHints[27];
    }
  return super.GetDescriptionText(PropName);
}

defaultproperties
{
  MyBlueTeamName="Blue Team"
  MyRedTeamName="red Team"
  EGSLogFileName="GameLog_%G_at_%A_(%Y_%M_%D_%H_%I_%S)"
  bEGSUseColoredNames=True
  bEGSUseColoredTeamNames=True
  bEGSShowTeamScoreEvents=True
  bEGSShowConnectsDisconnects=True
  bEGSReportGameEvents=True
  bEGSReportItemPickups=True
  bEGSShowSStatus=True
  bEGSUseGraphics=True
  bEGSdetailedplayerStats=True
  bIgnoreWarmupEvents=True
  bEGSLogTalks=True
  bDontLogKills=False
  EGSPlayerScoreEventsMode=1
  EGSReportHeavyDamageMode=0
  HDamageThreshold=2

  FriendlyName="Game Logger"
  Description="v4.0RC3|Creates HTML-report of the game."
  MouseOverHints(0)="Blue team name for team games, or 1st player name for 1x1 games."
  MouseOverHints(1)="Red team name for team games, or 2nd player name for 1x1 games."
  MouseOverHints(2)="Write player names in their team's color for team-based gametypes?"
  MouseOverHints(3)="Write team names in appropriate colors?"
  MouseOverHints(4)="Log the players' score events?"
  MouseOverHints(5)="Log team score events, like f.e. flag captures?"
  MouseOverHints(6)="Log players' connecting/disconnecting events?"
  MouseOverHints(7)="Log who and where picked up a weapon?"
  MouseOverHints(8)="Log pickups (Shield packs, health packs and others alike) being taken?"
  MouseOverHints(9)="Log game events (flags/bomb being taken dropped)?"
  MouseOverHints(10)="Add players' special status to name ([ADMIN]/[BOT]/[SPECTATOR])?"
  MouseOverHints(11)="Log players chat?"
  MouseOverHints(12)="Enter the future log file name, or it's mask here. Use the following variables to be replaced by appropriate values: '%G' - gametype; '%A' - map played; '%Y' - year; '%M' - month; '%D' - day; '%H' - hour; '%I' - minute and '%S' for seconds)"
  MouseOverHints(13)="Enter the server's IP address and a port if required (f.e. 192.168.0.1:7777) or usual address like ut2004.ru. Do not add 'ut2004://' prefix!"
  MouseOverHints(14)="Check this box if 1x1 game is played using Deathmatch gametype, so the team names fields are used for players' names"
  MouseOverHints(15)="Select the background color of the log. Attention: this option is ignored if you enabled 'Random background color' option. Note that not every HTML wrapper module supports multiple background colors."
  MouseOverHints(16)="If selected, every match the log background color will change on random base. Enabling this option makes mutator ignore selected background color."
  MouseOverHints(17)="Enable support of images in the log? See readme for details!"
  MouseOverHints(18)="If enabled, after the game is over stats for players (the one from individual stats screen) will be also dumped to the log."
  MouseOverHints(19)="Enable this option to turn on the World Stats Logging support. See readme file for details."
  MouseOverHints(20)="Defines the mode for logging heavy damage (75 and higher) infliction incients. 'Never' - disable damage logging; 'If vicims survives' - damage logged only if victim survived after recieving damage; 'Always' - logs damage no matter if the vicitm alive after the hit or not."
  MouseOverHints(21)="This is the threshold for the heavy damage logging. Inflicted damage lower than this value is not counted as heavy damage."
  MouseOverHints(22)="Available plugins providing extra stats. You may remove the ones you don't need."
  MouseOverHints(23)="Available plugins that add some comments on the current match into the main log. You may remove the ones you don't need."
  MouseOverHints(24)="Available plugins that allow GameLogger to recognize damage inflicted with non-standard weapons, for example damage from ECE vehicles."
  MouseOverHints(25)="If enabled logger will ignore all events that happen before match starts, for example in TTM2004 or UTComp warm up."
  MouseOverHints(26)="If enabled logger won't log usual kills, but will log suicides, teamkills, etc"
  MouseOverHints(27)="The level of privileges required to change GameLogger's setting via web-admin. Default is lowest - 1"
  ItemNames(0)="Blue Team or 2nd player Name."
  ItemNames(1)="Red Team or 1st player Name."
  ItemNames(2)="Team-based colored player names."
  ItemNames(3)="Colored team names."
  ItemNames(4)="Log players scoring events."
  ItemNames(5)="Log teams scoring events."
  ItemNames(6)="Log connects and disconnects."
  ItemNames(7)="Log weapons picking."
  ItemNames(8)="Log items being picked up."
  ItemNames(9)="Log game events."
  ItemNames(10)="Show special player status."
  ItemNames(11)="Log players' talks."
  ItemNames(12)="Log file name mask."
  ItemNames(13)="Server's Address."
  ItemNames(14)="The match is 1-on-1."
  ItemNames(15)="Log's background color."
  ItemNames(16)="Random background color."
  ItemNames(17)="Enable images in log."
  ItemNames(18)="Dump players' individual stats."
  ItemNames(19)="Enable World Stats Logging support."
  ItemNames(20)="Log heavy damage (check threshold below)"
  ItemNames(21)="Heavy damage threshold"
  ItemNames(22)="Allowed ExtraStats plugins"
  ItemNames(23)="Allowed Report plugins"
  ItemNames(24)="Allowed DamageType plugins"
  ItemNames(25)="Ignore warm-up events"
  ItemNames(26)="Don't log kills"
  ItemNames(27)="GameLogger Web-Admin privileges"
  Priv=1
  GroupName="GameStats"
}
