//-----------------------------------------------------------
//  Game Logger Report Plugin
//
// Base class for plugins containing functions providing
// additional reporting for gameplay events in mods/new
// gametypes, etc.
// This is added for simplicity of adding support for mods
// and also make the main mutator independent
// from the appropriate packages.
//
// I strongly recommend using the "GameLogger" prefix for
// your package name
//
//-----------------------------------------------------------
// This one is the most complicated. It's functions represnt
// ones in the GameStats and GameRules
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2004-2005
// if you want to use this code for your own purposes (i.e.
// your own project, I don't mean extensions for GameLogger)
// mail me first: senninha_r@mail.ru
//-----------------------------------------------------------
class GameLoggerReportPlugin extends GameLoggerplugin
	config(GameLogger)
	abstract;

// ============================================================================
// Pickup Event
// Called when someone picks something
// Other - pawn who picked that something
// item - is that something the pawn picked up
// ============================================================================
function PickupEvent(pawn Other, Pickup item);

// ============================================================================
// Score Event
// Called when someone completes some game goal
// Who - the scorer's PRI
// Points - how much points he recieved for that
// Desc - unique tag of the action. f.e. "flag_captured" or
// "enemy_core_destroyed"
// ============================================================================
function ScoreEvent(PlayerReplicationInfo Who, float Points, string Desc);

function TeamScoreEvent(int team, float points, string desc);

function NewGame(string ngTitle,
                 string ngAuthor,
                 string ngGameGameName,
                 string siServerName,
                 string siAdminName,
                 string siAdminEmail,
                 string siMOTD);

// ============================================================================
// ForThisGametype
//
// Called by the EGameStats when it loads report plugins. If plugin is
// successfully spawned this function is being called in it to check
// if this plugin suits for the current gametype. Return true to load plugin and
// False, to stop loading. Check the CTF Summary Plugin to see an example
// ============================================================================
function bool ForThisGametype(string GameName){
  return true;
}

// ============================================================================
// InitializePlugin
//
// Called right after the plugin is proved to be suitable for the current
// gametype (function above), and added EGameStats ReportPluguns array.
// It is highly recommended that all the stuff like spawning classes required
// for your plugin to work (like GameRules or FileLogs) is performed within
// InitialzePlugin. Now the plugin is being spawned once and the ForThisGametype
// function is being called, to check if the plugin suits for the current
// gametype. If not plugin is being destroyed. If it suits, than it's being
// added to plugins array. So, to avoid unnecessary classes being loaded, do
// all the class spawning here. I know that the above function can be called
// without spawning the class, if it is declared as 'static'. I haven't done so
// because if the plugins fail to spawn because it requires some packages that
// are missing, it is better if this happen on a test load, not when adding to
// array, as this will leave an empty entry in plugins array, causing an
// Accessed None each time EGameStats passes a function call to all report
// plugins.
// ============================================================================
function InitializePlugin();

// ============================================================================
//  PreStartGame
// Write to the log something right before the "Match Started" string;
// ============================================================================
function PreStartGame();

// ============================================================================
//  StartGame
// Write to the log something right after the "Match Started" string;
// ============================================================================
function StartGame();

// ============================================================================
//  ConnectEvent
// Someone connected to the server;
// ============================================================================
function ConnectEvent(PlayerReplicationInfo Who);

// ============================================================================
//  DisconnectEvent
// Someone (got) disconnected from the server;
// ============================================================================
function DisconnectEvent(PlayerReplicationInfo Who);

// ============================================================================
//  HDamageEvent
// Called when one of the players inflicts to another damage higher than 74%
// with non-instant kill damagetype;
// Function isn't called at all, if self.HeavyDamageReportMode is equal to 0;
// ============================================================================
function HDamageEvent(pawn ImHit, pawn ByMe, int Damage, class<DamageType> DamageType);

// ===========================================================================
// KillEvent
//
// Victim died from Damage...
// remebre that the killer may be none if he f.e. died because of being hit
// on the head with some mover.
// ===========================================================================
function KillEvent(string Killtype, PlayerReplicationInfo Killer, PlayerReplicationInfo Victim, class<DamageType> Damage);

// ===========================================================================
// gameEvent
//
// Called if someone changes the name or if the flag is being dropped, etc
// ===========================================================================
function GameEvent(string GEvent, string Desc, PlayerReplicationInfo Who);

// ===========================================================================
//  SpecialEvent
//
// Called if someone gets some spree or multikill level or if someone
// adrenalin activates
// ===========================================================================
function SpecialEvent(PlayerReplicationInfo Who, string Desc);

// ===========================================================================
//  BeforeReportEnd
// Called from EGameStats.EndGame before ending the main report table
// ===========================================================================
function BeforeReportEnd(array<PlayerReplicationInfo> PRIs, GameReplicationInfo GRI, string reason);

// ===========================================================================
//  AfterReportEnd
// Called from EGameStats.EndGame after ending the main report table but
// before starting the scoreboard
// ===========================================================================
function AfterReportEnd(array<PlayerReplicationInfo> PRIs, GameReplicationInfo GRI, string reason);

// ===========================================================================
//  AfterScoreboard
// Called from EGameStats.EndGame after writing the scoreboard,
// but before writing copyright notices;
// ===========================================================================
function AfterScoreboard(array<PlayerReplicationInfo> PRIs, GameReplicationInfo GRI, string reason);

event Destroyed()
{
	Super.Destroyed();
}

DefaultProperties
{
  FriendlyName="GameLogger Report plugin"
  Description=""
}
