//-----------------------------------------------------------
//  Game Logger support for TTM2004 accuracy and pickups
//  stats
//
//  Thanks to pakman of TTM team for his help.
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2005
//
// if you want to use this code for your own purposes (i.e.
// your own project, I don't mean extensions for GameLogger)
// mail me first: senninha_r@mail.ru
//-----------------------------------------------------------
class GameLoggerTTMStats extends GameLoggerExtraStatsPlugin;

// ============================================================================
// GetStandardWeaponInfo
//
// returns the standard info (the one you see on f3 screen) on specified weapon
// for specified player (Owner) depending on the switch:
// 0 - deaths holding that weapon
// 1 - death from that weapon
// 2 - kills with that weapon
// Doesn't seem to work properly yet =(
// ============================================================================

function int GetStandardWeaponInfo(PlayerReplicationInfo Owner, class<Weapon> Weapon, int sw){
  local int i, ourweapon, result;

  for (i = 0; i < TeamPlayerReplicationInfo(Owner).WeaponStatsArray.Length; i++ )
  {
    if (Weapon == TeamPlayerReplicationInfo(Owner).WeaponStatsArray[i].WeaponClass){
      ourweapon = i;
    }
  }
  if (sw == 2){
    result = TeamPlayerReplicationInfo(Owner).WeaponStatsArray[ourweapon].deathsholding;
  }
  else if (sw == 1){
    result = TeamPlayerReplicationInfo(Owner).WeaponStatsArray[ourweapon].deaths;
  }
  else if (sw == 0){
    result = TeamPlayerReplicationInfo(Owner).WeaponStatsArray[ourweapon].kills;
  }
  return result;
}

function TTM_PlayerReplicationInfo GetRelatedTTM_PRI(PlayerReplicationInfo PRI){
  local TTM_PlayerReplicationInfo TestPRI;
  local TTM_PlayerReplicationInfo result;

  foreach AllActors(class'TTM_PlayerReplicationInfo', TestPRI){
    if (TestPRI.PRI == PRI)
      result = TestPRI;
  }
  return result;
}

function GimmeStats(PlayerReplicationInfo PRI, GameReplicationInfo GRI, string TDstyle){
  // Note: TTM2004 does not spawn TTM_PlayerReplicationInfo for bots;
  if(BaseLogger.bTTMIsPresent && !PRI.bBot){
    Log("Writing down TTM stats for"@PRI.PlayerName);
    Logf("<tr>");
    Logf("<td colspan=2 width=100% align=center>");
    //starting the extended stats for TTM or UTComp
    Logf("<table class=textx>");
    Logf("  <tr>");
    Logf("  <td width=100 colspan=9 align=center><strong>TTM2004 stats</strong></td>");
    Logf("  </tr>");
    Logf("  <tr>");
    Logf("    <td width=100 align=center>Weapon</td>");
    Logf("    <td width=60 align=center>Shots</td>");
    Logf("    <td width=60 align=center>Hits</td>");
    Logf("    <td width=60 align=center>Dmg Given</td>");
    Logf("    <td width=60 align=center>Dmg Recived</td>");
    Logf("    <td width=60 align=center>Kills By</td>");
    Logf("    <td width=60 align=center>Killed By</td>");
    Logf("    <td width=60 align=center>Deaths Holding</td>");
    Logf("    <td width=60 align=center>Accuracy</td>");
    Logf("  </tr>");
  if ( (GetRelatedTTM_PRI(PRI).GetFired(0, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(0, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[1]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(0, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(0, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(0, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(0, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(0, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(0, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(0, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(0, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'AssaultRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'AssaultRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'AssaultRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(0, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(0, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(0, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(0, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(1, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(1, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[2]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(1, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(1, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(1, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(1, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(1, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(1, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(1, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(1, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'BioRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'BioRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'BioRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(1, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(1, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(1, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(1, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(2, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(2, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[3]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(2, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(2, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(2, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(2, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(2, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(2, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(2, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(2, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ShockRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ShockRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ShockRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(2, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(2, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(2, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(2, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(3, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(3, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[4]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(3, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(3, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(3, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(3, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(3, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(3, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(3, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(3, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'LinkGun', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'LinkGun', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'LinkGun', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(3, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(3, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(3, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(3, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(4, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(4, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[5]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(4, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(4, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(4, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(4, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(4, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(4, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(4, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(4, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'Minigun', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'Minigun', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'Minigun', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(4, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(4, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(4, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(4, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(5, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(5, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[6]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(5, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(5, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(5, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(5, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(5, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(5, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(5, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(5, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'FlakCannon', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'FlakCannon', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'FlakCannon', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(5, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(5, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(5, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(5, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(6, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(6, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[7]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(6, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(6, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(6, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(6, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(6, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(6, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(6, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(6, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'RocketLauncher', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'RocketLauncher', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'RocketLauncher', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(6, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(6, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(6, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(6, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(7, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(7, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[8]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(7, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(7, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(7, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(7, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(7, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(7, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(7, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(7, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SniperRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SniperRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SniperRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(7, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(7, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(7, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(7, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(9, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(9, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[9]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(9, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(9, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(9, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(9, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(9, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(9, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(9, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(9, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ClassicSniperRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ClassicSniperRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'ClassicSniperRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(9, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(9, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(9, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(9, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(8, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(8, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[16]$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(8, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(8, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(8, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(8, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(8, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(8, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(8, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(8, false, true))$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SuperShockRifle', 0)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SuperShockRifle', 1)$"</td>");
    Logf("    <td align=center>"$GetStandardWeaponInfo(PRI, class'SuperShockRifle', 2)$"</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(8, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(8, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(8, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(8, false)$"%</td>");
    Logf("  </tr>");
  }
  if ( (GetRelatedTTM_PRI(PRI).GetFired(10, true) > 0 ) ||  (GetRelatedTTM_PRI(PRI).GetFired(10, false) > 0 ))
  {
    Logf("  <tr>");
    Logf("    <td align=left>"$baseLogger.PickedWeaponNames[3]@"Combo</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetFired(10, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetFired(10, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetHit(10, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetHit(10, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(10, true, false))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(10, false, false))$"</td>");
    Logf("    <td align=center>"$int(GetRelatedTTM_PRI(PRI).GetDamage(10, true, true))$"/"$int(GetRelatedTTM_PRI(PRI).GetDamage(10, false, true))$"</td>");
    Logf("    <td align=center>-</td>");
    Logf("    <td align=center>-</td>");
    Logf("    <td align=center>-</td>");
    Logf("    <td align=center>"$(GetRelatedTTM_PRI(PRI).GetFired(10, true)/100)*GetRelatedTTM_PRI(PRI).GetHit(10, true)$"%/"$(GetRelatedTTM_PRI(PRI).GetFired(10, false)/100)*GetRelatedTTM_PRI(PRI).GetHit(10, false)$"%</td>");
    Logf("  </tr>");
  }
  Logf("  <tr>");
  Logf("    <td align=left>Total Damage</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("    <td align=center colspan=2>"$int(GetRelatedTTM_PRI(PRI).GetTotalDamage(false))$"/"$int(GetRelatedTTM_PRI(PRI).GetTotalDamage(true))$"</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("    <td align=center>&nbsp;</td>");
  Logf("  </tr>");
  Logf("</table>");
  Logf("</td>");
  Logf("</tr>");
  }
}

function LogF(string LogString){
 baseLogger.Logf(LogString);
}

DefaultProperties
{
  FriendlyName="GameLogger TTM stats plugin"
  Description="Retrives from TTM accuracy and pickups stats"
  Author="Michael \"_Lynx\" Sokolkov"
  version="1.0a"
}
