//-----------------------------------------------------------
//
//-----------------------------------------------------------
class GameLoggerJBReport extends GameLoggerReportPlugin;

var JBGameRules JBGR;
var int BLPrevScoreMode;
// ============================================================================
// Jailbreak events
// ============================================================================
var localized string JBWinsTheArena,
                     JBNewRound,
                     JBReconnected,
                     JBGotLlamalizedForReconnecting,
                     JBReleases,  // i.e. player releases gold team
                     JBGotExecuted,
                     JBArenaMatchStarted,
                     JBSentToJail;

function bool ForThisGametype(string GameName){
  if (GameName ~= "Jailbreak")
   return true;
  else
   return false;
}

// spawning hook for us.
function InitializePlugin(){

  JBGR = spawn(class'JBLogHook', self);

  if ( Level.Game.GameRulesModifiers == None )
    Level.Game.GameRulesModifiers = JBGR;
  else
    Level.Game.GameRulesModifiers.AddGameRules(JBGR);

  BLPrevScoreMode = baseLogger.PlayerScoreEventsMode; //saving to restore after the game
  baseLogger.PlayerScoreEventsMode = 0; //disabling
}


function LogJBEvent(string what, optional PlayerReplicationInfo who_did, optional int team_index )
{
  local string JBEvent;

  if (what ~= "arena_match_started"){
    JBEvent = baseLogger.myHTMLwrapper.B(JBArenaMatchStarted);
  }
  // No "new round started" if one of the teams reaches || exceeds goalscore
  else if (what ~= "new_round" && ( (Level.Game.GameReplicationInfo.Teams[0].Score < Level.Game.GoalScore) || (Level.Game.GameReplicationInfo.Teams[1].Score < Level.Game.GoalScore))){
    JBEvent = baseLogger.myHTMLwrapper.B(JBNewRound);
  }
  else if (what ~= "player_reconnect_llamalized"){
    JBEvent = baseLogger.myHTMLwrapper.B(baseLogger.CCName(who_did))@JBGotLlamalizedForReconnecting;
  }
  else if (what ~= "player_reconnect"){
    JBEvent = baseLogger.myHTMLwrapper.B(baseLogger.CCName(who_did))@JBReconnected;
  }
  else if (what ~= "arena_match_started"){
    JBEvent = baseLogger.myHTMLwrapper.B(JBArenaMatchStarted);
  }
  else if (what ~= "player_won_arena"){
    JBEvent = baseLogger.myHTMLwrapper.B(baseLogger.CCName(who_did))@JBWinsTheArena;
  }
  else if (what ~= "player_sent_to_jail"){
    JBEvent = baseLogger.myHTMLwrapper.B(baseLogger.CCName(who_did))@JBSentToJail;
  }
  else if (what ~= "team_released"){
    JBEvent = baseLogger.myHTMLwrapper.B(baseLogger.CCName(who_did))@JBReleases@baseLogger.myHTMLwrapper.B(baseLogger.CTName(team_index));
  }
  else if (what ~= "team_executed"){
    JBEvent = "Team"@baseLogger.myHTMLwrapper.B(baseLogger.CTName(team_index))@JBGotExecuted;
  }

  if (bDebug) {
    baseLogger.Logf("<!-- Jail Break Event-->");
  }

  baseLogger.myHTMLwrapper.WriteSingleReportString(baseLogger.TimeStamp(), JBEvent);
}

function AfterScoreboard(array<PlayerReplicationInfo> PRIs, GameReplicationInfo GRI, string reason){

   baseLogger.PlayerScoreEventsMode = BLPrevScoreMode;
}

DefaultProperties
{
  FriendlyName="JB Reporter"
  Description="Plugin for JB support"
  Author="Michael \"_Lynx\" Sokolkov"
  JBWinsTheArena="earns the freedom in the arena match!"
  JBNewRound="New round started!"
  JBReconnected="gets back to the action."
  JBGotLlamalizedForReconnecting="got llamalized for reconnecting while in jail."
  JBReleases="releases"
  JBGotExecuted="has been captured!"
  JBArenaMatchStarted="Arena match has started!"
  JBSentToJail="was sent to jail."
  version="1.0b"
}
