// -----------------------------------------------------------
//  UTXMPManualStyledWrapper
//
// This wrapper changes the style of the log to look similar
// to the UTXMP manual.
// Just made some changes to <BODY> and styles.
// Note that this wrapper completely ignores selected
// backgound color. It's background is always black
// -----------------------------------------------------------
class UTXMPManualStyledWrapper extends GameLoggerHTMLwrapper
	config(GameLogger);

function expStyle(){
  Logf("<style type=\"text/css\">");
  Logf(" .text{");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 11px;");
  Logf(" }");
  Logf(" .textX{");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 10px;");
  Logf(" color: #000000;");
  Logf(" }");
  Logf(" .textsmall{");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 10px;");
  Logf(" color : #000000;");
  Logf(" }");
  Logf(" TABLE.a{");
  Logf(" border : 1px solid #7B6262;");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 10px;");
  Logf(" }");
  Logf(" TABLE.b{");
  Logf(" background-color: #000000;");
  Logf(" border : 0px solid Black;");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 11px;");
  Logf(" color: #FF9900;");
  Logf(" }");
  Logf(" TABLE.top{");
  Logf(" background-color : White;");
  Logf(" border-bottom : 2px solid Black;");
  Logf(" border-left : 0px solid Black;");
  Logf(" border-right : 0px solid Black;");
  Logf(" border-top : 0px solid Black;");
  Logf(" }");
  Logf(" .heading{");
  Logf(" font-family: \"Trebuchet MS\", Arial;");
  Logf(" font-size: 18px;");
  Logf(" font-weight: bold;");
  Logf(" font-style: italic;");
  Logf(" color: #FFFFFF;");
  Logf(" }");
  Logf(" TABLE.ScoreB{");
  Logf(" border : 1px solid Black;");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 13px;");
  Logf(" color : #000000;");
  Logf(" background : #6495ED;");
  Logf(" }");
  Logf(" TABLE.ScoreR{");
  Logf(" border : 1px solid Black;");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 13px;");
  Logf(" color : #000000;");
  Logf(" background : #FF6347;");
  Logf(" }");
  Logf(" TABLE.ScoreU{");
  Logf(" border : 1px solid Black;");
  Logf(" font-family : Verdana;");
  Logf(" font-size : 13px;");
  Logf(" color : #000000;");
  Logf(" background : #FFFAF0;");
  Logf(" }");
  Logf(" A:link.rest {");
  Logf(" color: #FF9900;");
  Logf(" font-weight: normal;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: none;");
  Logf(" }");
  Logf(" A:visited.rest {");
  Logf(" color: #FF9900;");
  Logf(" font-weight: normal;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: none;");
  Logf(" }");
  Logf(" A:hover.rest {");
  Logf(" COLOR: #FFFF00;");
  Logf(" font-weight: bold;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: none;");
  Logf(" }");
  Logf(" A:link.score {");
  Logf(" COLOR: black;");
  Logf(" font-weight: normal;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: none;");
  Logf(" }");
  Logf(" A:visited.score {");
  Logf(" color: black;");
  Logf(" font-weight: normal;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: none;");
  Logf(" }");
  Logf(" A:hover.score {");
  Logf(" COLOR: navy;");
  Logf(" font-weight: bold;");
  Logf(" font-style: normal;");
  Logf(" font-variant: normal;");
  Logf(" text-decoration: underline;");
  Logf(" }");
  Logf(" .say{");
  Logf(" color: #DAA520;");
  Logf(" }");
  Logf(" .teamsay_red{");
  Logf(" color: #F08080;");
  Logf(" }");
  Logf(" .teamsay_blue{");
  Logf(" color: #87CEEB;");
  Logf(" }");
  Logf(" .item_pickup{");
  Logf(" color: #9FFF88;");
  Logf(" }");
  Logf(" .weapon_pickup{");
  Logf(" color: #FFE188;");
  Logf(" }");
  Logf(" .HdamageEvent{");
  Logf(" color : #DB7093;");
  Logf(" }");
  Logf(" TD.ScoreR{");
  Logf(" border-bottom : 1px solid #FF4322;");
  Logf(" }");
  Logf(" TD.ScoreB{");
  Logf(" border-bottom : 1px solid #296BE7;");
  Logf(" }");
  Logf(" TD.ScoreU{");
  Logf(" border-bottom : 1px solid #FFEBBF;");
  Logf(" }");
  Logf("</style>");
}

function WriteHeader (string GameType, string MapName)
{
  Logf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
  Logf("<HTML><HEAD>");
  Logf("<TITLE>Details on logged match played on"@BaseLogger.FullTimeDate()@":"@GameType@" at "@MapName@"</title>");
  Logf("<meta name=\"Generator\" content=\"UnrealEngine2 build "$Level.EngineVersion$" - exporter: "$string(BaseLogger.Class)$" v."$BaseLogger.version@"by _Lynx\">");
  expStyle();
  Logf("</head><body bgcolor=\"#000000\" rightmargin=\"0\" leftmargin=\"0\" topmargin=\"0\" text=\"#ffffff\" class=text>");
  Logf("<!-- Settings used");
  Logf("bUseColoredNames is"@BaseLogger.bUseColoredNames);
  Logf("bUseColoredTeamNames is"@BaseLogger.bUseColoredTeamNames);
  Logf("PlayerScoreEventsMode is"@BaseLogger.PlayerScoreEventsMode);
  Logf("bShowTeamScoreEvents is"@BaseLogger.bShowTeamScoreEvents);
  Logf("bShowConnectsDisconnects"@BaseLogger.bShowConnectsDisconnects);
  LOgf("bLogOtherPicks is"@BaseLogger.bLogOtherPicks);
  logf("bLogWeaponsPicks is"@BaseLogger.bLogWeaponsPicks);
  logf("bShowSStatus is"@BaseLogger.bShowSStatus);
  Logf("bReportGameEvents is"@BaseLogger.bReportGameEvents);
  Logf("bUseGraphics is"@bUseGraphics);
  Logf("bWSLenabled is"@BaseLogger.bWSLenabled);
  Logf("bLogTalks is"@BaseLogger.bLogTalks);
  Logf("HeavyDamageReportMode is"@BaseLogger.HeavyDamageReportMode);
  Logf("bLogTalks is"@BaseLogger.bDuelMode);
  Logf("-->");
  if(bUseGraphics){
    Logf("<table class=\"top\" width=\"100%\">");
    Logf("<tr>");
    Logf("    <td width=\"100\" align=left><a href=\"http://www.epicgames.com\" class=\"rest\"><img src=\"gameloggerimages/"$imagessubfolder$"/epic.gif\" border=0></a></td><td width=\"*\" align=center><div align=\"center\"><a href=\"http://www.unrealtournament.com\"><Img border=\"0\" src=\"gameloggerimages/"$imagessubfolder$"/ut2k4.jpg\"></a></div></td><td width=100 align=right><a href=\"http://www.atari.com\" class=\"rest\"><img src=\"gameloggerimages/"$imagessubfolder$"/atari.gif\" border=0></a></td>");
    Logf("</tr>");
    Logf("</table>");
  }
}

// ============================================================================
// WriteMatchInfo
//
// Writes down server settings and rules for the starting match
// ============================================================================

function WriteMatchInfo(string ngTitle,
                        string ngAuthor,
                        string ngGameGameName,
                        string siServerName,
                        string siAdminName,
                        string siAdminEmail,
                        string siMOTD ){

  local string Player1;
  local string player2;
  local string blueTeamName;
  local string redTeamName;
  local string MutDesc;

  local int FragLimit;
  local int TimeLimit;
  local int MaxSpectators;
  local int NumBots;
  local int MaxPlayers;

  local bool bAllowBehindView;
  local bool bAllowWeaponThrowing;
  local bool bWeaponStay;
  local bool bWeaponShouldViewShake;
  local bool bNoNamesProvided;

  local float GameSpeed;

  local mutator MyMutie;
  local GamereplicationInfo GRI;

  FragLimit              = Level.Game.GoalScore;
  TimeLimit              = Level.Game.TimeLimit;
  GameSpeed              = Level.Game.GameSpeed;
  MaxSpectators          = Level.Game.MaxSpectators;
  NumBots                = Level.Game.NumBots;
  MaxPlayers             = Level.Game.MaxPlayers;
  bAllowBehindView       = Level.Game.bAllowBehindView;
  bAllowWeaponThrowing   = Level.Game.bAllowWeaponThrowing;
  bWeaponShouldViewShake = Level.Game.bWeaponShouldViewShake;
  bWeaponStay            = Level.Game.bWeaponStay;

  GRI = Level.Game.GameReplicationInfo;

  blueTeamName = GRI.Teams[1].TeamName;
  redTeamname  = GRI.Teams[0].TeamName;

  if (baseLogger.bDuelMode &&
			class'MutGameLogger'.default.MyBlueTeamName != "" &&
			class'MutGameLogger'.default.MyRedTeamName != ""){
    Player1 = class'MutGameLogger'.default.MyRedTeamName;
    Player2 = class'MutGameLogger'.default.MyBlueTeamName;

  }
  else {
    bNoNamesProvided = True;
  }

  if(bUseGraphics){
    Logf("<br>");
    Logf("<div align=center><a href=\"http://www.free-monkey.com/\" class=rest><img src=\"gameloggerimages/"$imagessubfolder$"/logo.png\" border=0></a></div>");
    Logf("<br>");
    Logf("<br>");
  }
  if (baseLogger.IsTeamGame){
    Logf("<div align=center class=heading>");
    Logf("");
    Logf(redTeamName@"vs"@blueTeamName);
    Logf("<div align=center class=text>");
    Logf("Match played on"@baseLogger.FullTimeDate());
    Logf("</div>");
    Logf("</div>");
    Logf("<br>");
  }
    else if (baseLogger.bDuelMode && !bNoNamesProvided){
    Logf("<div align=center class=heading>");
    Logf("<br><br>");
    Logf(Player1@"vs"@Player2);
    Logf("<div align=center class=text>");
    Logf("Match played on"@baseLogger.FullTimeDate());
    Logf("</div>");
    Logf("</div>");
    Logf("<br>");
  }
  else{
    Logf("<br><br>");
  }

  Logf("<div align=\"center\">");
  Logf("<table width=600 class=\"b\" border=1>");
  Logf("<tr>");
  Logf("<td width=200>Arena Name</td><td colspan=3 width=400>"$ngTitle$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>Admin:</td><td colspan=3 width=400>"$siAdminName$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>e-mail:</td><td colspan=3 width=400><a href=\"mailto:"$siAdminEmail$"\" class=rest>"$siAdminEmail$"</a></TD>");
  Logf("</tr>");
  Logf("<tr>");
  if(baseLogger.serverIP != ""){
  	Logf("<td width=200>Server Name:</td><td colspan=3 width=400><a href=\"ut2004://"$BaseLogger.serverIP$"\" class=rest>"$siServerName$"</a></TD>");
  }
  else{
    Logf("<td width=200>"$baseLogger.ServerName$"</td><td colspan=3 width=400>"$siServerName$"</TD>");
  }
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td width=200>Server Type</td><td colspan=3 width=400>"$GetServerType()$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td colspan=4 align=center width=100%>"$B("Mutators used:")$"</td>");
  Logf("</tr>");
  FillMutDefs();
  foreach AllActors(class'Mutator',MyMutie)
  {
     MutDesc = MyMutie.default.Description;
     replacetext (MutDesc, "|", "<BR>");
     Logf("<tr>");
     Logf("<td align=left width=200 valign=top>"$MyMutie.default.FriendlyName$"("$MyMutie.Class$")</TD>");
     Logf("<TD colspan=3 align=left width=400>"$MutDesc$"&nbsp;</TD>");
     Logf("</tr>");
  }
  ClearMutDefs();
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td colspan=4 align=center width=100%>"$B("Game Rules")$"</td>");
  Logf("</TR>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Goal Score:</strong></TD><TD colspan=3>"$FragLimit$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Timelimit:</strong></TD><TD colspan=3>"$TimeLimit$" min.</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Weapon Stay:</strong></TD><TD colspan=3>"$bWeaponstay$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Gamespeed</strong></TD><TD colspan=3>"$int(Gamespeed * 100)$"%</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Bot Mode</strong></TD><TD colspan=3>"$DecodeBotMode(UnrealMPGameInfo(Level.Game).BotMode)$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Spawn Protection Time</strong></TD><TD colspan=3>"$int(DeathMatch(Level.Game).SpawnProtectionTime)$" sec.</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Weapon Shakes View</strong></TD><TD colspan=3>"$bWeaponShouldViewShake$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Behind View</strong></TD><TD colspan=3>"$Level.Game.bAllowBehindView$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Weapon Throwing</strong></TD><TD colspan=3>"$Level.Game.bAllowWeaponThrowing$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Allow Translocator</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bAllowTrans$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Force Respawn</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bForceRespawn$"</TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=left width=400><strong>Colored DM Skins</strong></TD><TD colspan=3>"$DeathMatch(Level.Game).bColoredDMSkins$"</TD>");
  Logf("</tr>");

  if (baseLogger.IsTeamGame){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Friendly Fire Scale</strong></TD><TD colspan=3>"$int(TeamGame(Level.Game).FriendlyFireScale * 100)$"%</TD>");
    Logf("</tr>");
  }

  if (Level.GetGameClass() == class'ONSOnslaughtGame'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Overtime Core Drainage</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).OvertimeCoreDrainPerSec$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Team Swap Sides</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).bSwapSidesAfterReset$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Link Setup Used:</strong></TD><TD colspan=3>"$ONSOnslaughtGame(Level.Game).CurrentSetupName$"</TD>");
    Logf("</tr>");
  }

  if (Level.GetGameClass() == class'xBombingRun'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Ball Launcher Drains Traslocator</strong></TD><TD colspan=3>"$xBombingRun(Level.Game).bBallDrainsTransloc$"</TD>");
    Logf("</tr>");
  }
  if (Level.GetGameClass() == class'ASGameInfo'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Round Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).RoundLimit$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Round Time Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).RoundTimeLimit$"</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Reinforcement Frequency</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).ReinforcementsFreq$" sec.</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Online Practice Time Limit</strong></TD><TD colspan=3>"$ASGameInfo(Level.Game).PracticeTimeLimit$" sec.</TD>");
    Logf("</tr>");
  }
  if (Level.GetGameClass() == class'xDoubleDom'){
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Time To Score</strong></TD><TD colspan=3>"$xDoubleDom(Level.Game).TimeToScore$" sec.</TD>");
    Logf("</tr>");
    Logf("<tr>");
    Logf("<td align=left width=400><strong>Time Disabled</strong></TD><TD colspan=3>"$xDoubleDom(Level.Game).TimeDisabled$" sec.</TD>");
    Logf("</tr>");
  }

  Logf("<tr>");
  Logf("<td align=center colspan=4 width=100%><strong>Message Of The Day</strong></TD>");
  Logf("</tr>");
  Logf("<tr>");
  Logf("<td align=center colspan=4 width=100%>"$siMOTD$"</TD>");
  Logf("</tr>");
  Logf("</table>");
  Logf("</div>");
  LogF("<BR>");
  LogF("<BR>");
  StartReportTable();
}

function WriteEnding(string winner){
  Logf("<br>");
  Logf("<br>");
  if (bUseGraphics){
    Logf("<table width=100% height=49 border=0 cellspacing=\"-2\">");
    Logf("<tr>");
    Logf("<td width=81 background=\"gameloggerimages/"$imagessubfolder$"/bar1.gif\" height=\"49\"></td>");
    Logf("<td width=\"*\" height=\"49\" background=\"gameloggerimages/"$imagessubfolder$"/bar2.gif\" class=heading><font color=white><strong><div align=\"center\">"$Winner@"wins the match</div></strong></font></td>");
    Logf("</tr>");
    Logf("</table>");
  }
  else{
    Logf("<hr width=95% size=1 noshade>");
  }
  Logf("<br>");
  Logf("Log design is based on manual for <a href=\"http://www.free-monkey.com/\" class=rest>UTXMP (Unreal Tournament eXpanded MultiPlayer)</a>, a mod for <a href=\"http://www.unrealtournament.com/\" class=rest>UT2004</a> made by <a href=\"http://www.free-monkey.com/\" class=rest>Free Monkey Interactive</a>");
  Logf("<br>");
  Logf("<br>");
}

DefaultProperties
{
 imagessubfolder="utxmpmanualstyle"
}
