//-----------------------------------------------------------
// JailBreak Log Hook for Game Logger
// Created by: Michael "_Lynx" Sokolkov
// Date      : 14.11.2004
// Version  : 1.2
//-----------------------------------------------------------
// Thanks to Mychaeel from JailBreak team for his help in
// making this GL module.
//
// v1.0 All Basic functions are done
// v1.1 Made the class independendent from JBAddonGameLog
//      which was removed to keep things server-side
// v1.2 Fixed massive "sent to jail" spam between rounds and
//      made the main GameLogger module not to require
//      Jailbreak.u to work.
//-----------------------------------------------------------
class JBLogHook extends JBGameRules;

var EGameStats EGameStatsClass;
var GameLoggerJBReport JBReporter;

var int PrevHeavyDamageReportMode;

var bool bIsInitialized;
var bool bBetweenRounds;
var bool bNoMoreRounds;

function PreBeginPlay(){
  Super.PreBeginPlay();

  bBetweenRounds=True;

  if (Owner != None){
    Log("Jailbreak Hook for Gamelogger is spawned, owner is"@Owner);
    JBReporter = GameLoggerJBReport(Owner);
    EGameStatsClass = JBReporter.BaseLogger;
  }
  else{
    Log("Jailbreak Hook for Gamelogger is spawned, but it's owner is None");
  }
}

// ============================================================================
// NotifyRound
//
// Called when a game round starts, including the first round in a game.
// ============================================================================

function NotifyRound()
{
  local JBGameRules nextJBGameRules;

	if (!bNoMoreRounds)
    JBReporter.LogJBEvent("new_round");

  bBetweenRounds=False;

  nextJBGameRules = GetNextJBGameRules();

  if (nextJBGameRules != None)
    nextJBGameRules.NotifyRound();
}

// ============================================================================
// NotifyPlayerReconnect
//
// Called when a human player reconnects to an ongoing match after having
// disconnected from it before. Not called for a player's initial connection
// to a game. The bIsLlama parameter tells whether the player left within the
// same round they reconnected and was in jail when they disconnected.
// ============================================================================

function NotifyPlayerReconnect(PlayerController ControllerPlayer, bool bIsLlama)
{
  local JBGameRules nextJBGameRules;

  if (bIsLlama)
    JBReporter.LogJBEvent("player_reconnect_llamalized", ControllerPlayer.PlayerReplicationInfo);
  else
    JBReporter.LogJBEvent("player_reconnect", ControllerPlayer.PlayerReplicationInfo);

  nextJBGameRules = GetNextJBGameRules();

  if (nextJBGameRules != None)
    nextJBGameRules.NotifyPlayerReconnect(ControllerPlayer, bIsLlama);
}

// ============================================================================
// NotifyArenaStart
//
// Called direcly after both arena combatants have been spawned in the arena.
//
// Makes logger write a "Arena match started" message
// ============================================================================

function NotifyArenaStart(JBInfoArena Arena)
{
  local JBGameRules nextJBGameRules;

  JBReporter.LogJBEvent("arena_match_started");

  nextJBGameRules = GetNextJBGameRules();
  if (nextJBGameRules != None)
    nextJBGameRules.NotifyArenaStart(Arena);
}


// ============================================================================
// NotifyArenaEnd
//
// Called when an arena match has been decided, directly after the winner (if
// any) has been respawned in freedom. The loser might have respawned in jail
// a short time earlier already.
//
// Makes logger write a "%p won the arena" message and removes both players
// from the combatants array and sets the LastArenaLoser and prevent "sent to
// jail" message for him. But... only if  ![quote=mychaeel]The loser might
// have respawned in jail a short time earlier already.[/quote]
// ============================================================================

function NotifyArenaEnd(JBInfoArena Arena, JBTagPlayer TagPlayerWinner)
{
  local JBGameRules nextJBGameRules;
  local PlayerReplicationInfo thisPRI;

  thisPRI = TagPlayerWinner.GetPlayerReplicationInfo();
 // if (EGameStatsClass != None)
  JBReporter.LogJBEvent("player_won_arena", thisPRI);

  nextJBGameRules = GetNextJBGameRules();
  if (nextJBGameRules != None)
    nextJBGameRules.NotifyArenaEnd(Arena, TagPlayerWinner);
}


// ============================================================================
// NotifyPlayerJailed
//
// Called when a player enters a jail, for instance by being spawned there
// after being killed, or by being sent there after losing an arena fight, or
// by simply physically walking into it.
//
// Makes logger write a  "%p sent to jail" message if the game is not between
// rounds.
// ============================================================================

function NotifyPlayerJailed(JBTagPlayer TagPlayer)
{
  local JBGameRules nextJBGameRules;
  local PlayerReplicationInfo thisPRI;

  thisPRI = TagPlayer.GetPlayerReplicationInfo();
  if (!bBetweenRounds)
    JBReporter.LogJBEvent("player_sent_to_jail", thisPRI);

  nextJBGameRules = GetNextJBGameRules();
  if (nextJBGameRules != None)
    nextJBGameRules.NotifyPlayerJailed(TagPlayer);
}

// ============================================================================
// CanRelease
//
// Called when a player attempts to release a team by activating a release
// switch. Returning False will prevent the release; in that case the
// objectives for this jail will remain disabled for a short time before
// they are activated again.
//
// Makes logger write a "%t has been released" message
// ============================================================================

function bool CanRelease(TeamInfo Team, Pawn PawnInstigator, GameObjective Objective)
{
  local JBGameRules nextJBGameRules;

  JBReporter.LogJBEvent("team_released", PawnInstigator.PlayerReplicationInfo, Team.TeamIndex);

  nextJBGameRules = GetNextJBGameRules();
  if (nextJBGameRules != None)
    return nextJBGameRules.CanRelease(Team, PawnInstigator, Objective);

  return True;
}

// ============================================================================
// NotifyExecutionCommit
//
// Called when a team is about to be executed, before the execution sequence
// starts and directly after the other players' views switch to the execution
// camera.
//
// Makes the logger write a "%t was jailed" message and also disables
// HeavyDamageLogging in GameLogger main module so that it wont log an
// insane damage being inflicted out of the blue by someone unknown
// ============================================================================

function NotifyExecutionCommit(TeamInfo Team)
{
  local JBGameRules nextJBGameRules;

  bBetweenRounds=true;

  JBReporter.LogJBEvent("team_executed", ,Team.TeamIndex);
  PrevHeavyDamageReportMode = EgameStatsClass.HeavyDamageReportMode;
  EgameStatsClass.HeavyDamageReportMode = 0;

  if ((Level.Game.GameReplicationInfo.Teams[0].Score >= Level.Game.GoalScore ||
       Level.Game.GameReplicationInfo.Teams[1].Score >= Level.Game.GoalScore) && Level.Game.GoalScore > 0)
    bNoMoreRounds = True;
  else if (Level.Game.bOverTime)
    bNoMoreRounds = True;

  nextJBGameRules = GetNextJBGameRules();

  if (nextJBGameRules != None)
  nextJBGameRules.NotifyExecutionCommit(Team);
}

// ============================================================================
// NotifyExecutionEnd
//
// Called when the execution sequence has been completed, directly before the
// next round starts.
//
// The execution sequence is ended, and the losers are punished. Now we can
// reenable HeavyDamageLogging, so the function restores the previous value of
// HeavyDamageReportMode.
// ============================================================================

function NotifyExecutionEnd()
{
  local JBGameRules nextJBGameRules;

  EgameStatsClass.HeavyDamageReportMode = PrevHeavyDamageReportMode;

  nextJBGameRules = GetNextJBGameRules();
  if (nextJBGameRules != None)
    nextJBGameRules.NotifyExecutionEnd();
}

DefaultProperties
{

}
