//-----------------------------------------------------------
//  Game Logger Weapon Damage Plugin
//
// Base class for plugins containing names of additional
// damage type and corresponding damage strings.
// For adding support for various mods.
// This is added for simplicity of adding support for new
// damagetypes and also make the main mutator independent
// from the packages containing this damagetypes.
//
// I strongly recommend using the "GameLogger" prefix for
// your package name
//-----------------------------------------------------------
//  by Michael "_Lynx" Sokolkov  2005
//-----------------------------------------------------------
class GameLoggerWeaponDamagePlugin extends GameLoggerPlugin
	hidecategories(Movement,Collision,Lighting,LightColor,Karma,Force,Events,Display,Collision,Advanced)
  abstract;

struct DamageTypeNameAction{
 var() class<DamageType> thisDamageType; // The damagetype class, will look like "class'Engine.Damatype'"
 var() string thisAction;                // The name of the weapon making this damage, without "by". The string must have
 var() bool bDontLogHD;                  // spaces on both ends. Look at the comments further for and example
};                                       // bDontLogHD. Set to true to for the instakill (250/300HP and higher) damage types
                                         // f.e. this is set to true for Goliath cannon shot as we know that the victim
                                         // will die in 99,9% percents of being shot by tank shell.

var() array<DamageTypeNameAction> ExtraDamageType;

// ===========================================================================
// DontHDThisDamage
//
// a function used when checking if this damage whould be logged in heavy
// damage event. Called from GameLoggerRules
// ===========================================================================
function bool DontHDThisDamage(class<DamageType> testdamage){
  local int i;
  local bool bFound;

  for (i = 0; i < ExtraDamageType.Length; i++ ){
		if (testdamage == ExtraDamageType[i].thisDamageType){
			if (ExtraDamageType[i].bDontLogHD){
				bFound = True;
				return true;
			}
		}
  }
  if (!bFound)
  	return false;
}

//Here's how the default properies sholud look for f.e. ECE vehicles:
//defaultproperties
//{
//     ExtraDamageType(0)=(thisDamageType=Class'OnslaughtBP.DamTypeArtilleryShell',thisAction=" SPMA's artillery shell ")
//     ExtraDamageType(1)=(thisDamageType=Class'OnslaughtBP.DamTypeONSCicadaLaser',thisAction=" Cicada's turret's lasers ")
//     ExtraDamageType(2)=(thisDamageType=Class'OnslaughtBP.DamTypeONSCicadaRocket',thisAction=" Cicada's rocket ")
//     ExtraDamageType(3)=(thisDamageType=Class'OnslaughtBP.DamTypeShockTankProximityExplosion',thisAction=" Paladin's combo ")
//     ExtraDamageType(4)=(thisDamageType=Class'OnslaughtBP.DamTypeShockTankShockBall',thisAction=" Paladin's shock ball ")
//}
// So copy-paste from here and edit on your own, or load up UnrealEd and work from there.

DefaultProperties
{
  FriendlyName="GameLogger additional DamageType plugin"
  Description=""
}
