///////////////////////////////////////////////////////////////////////////////
// MutLinkMe
// by Kamek (neokamek@gmail.com)
// A mutator that enhances bot functionality with the link guns.
// Intended for Onslaught but works great in other game types.
///////////////////////////////////////////////////////////////////////////////

class MutLinkMe extends Mutator;

///////////////////////////////////////////////////////////////////////////////
// Vars, structs, consts, etc.
///////////////////////////////////////////////////////////////////////////////
var() class<AIController> BotClass;		// Class of bot to use

///////////////////////////////////////////////////////////////////////////////
// PreBeginPlay
// Make the default xPawn controller class our new bot class.
// Has to be done here instead of in ModifyPlayer() because the controller has
// already spawned by then.
///////////////////////////////////////////////////////////////////////////////
event PreBeginPlay()
{
	/*
	if (ONSOnslaughtGame(Level.Game) == None)
	{
		warn("MutLinkMe: No Onslaught game -- NOT replacing default controller class.");
		return;
	}
	*/
	class'xPawn'.default.ControllerClass = BotClass;
	log("MutLinkMe: Controller class replaced with our bot class.");
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
defaultproperties
{
	BotClass = class'xLinkMeBot'
	FriendlyName = "Link Me, Dammit!"
	Description = "Allied bots will try to link up with you more often."
}