///////////////////////////////////////////////////////////////////////////////
// LinkMeServerActor
// by Kamek (neokamek@gmail.com)
// ServerActor version of MutLinkMe (won't make servers non-standard)
///////////////////////////////////////////////////////////////////////////////
class LinkMeServerActor extends Actor;

///////////////////////////////////////////////////////////////////////////////
// Vars, structs, consts, etc.
///////////////////////////////////////////////////////////////////////////////
var() class<AIController> BotClass;		// Class of bot to use

///////////////////////////////////////////////////////////////////////////////
// PreBeginPlay
// Make the default xPawn controller class our new bot class.
// Has to be done here instead of in ModifyPlayer() because the controller has
// already spawned by then.
///////////////////////////////////////////////////////////////////////////////
event PreBeginPlay()
{
	/*
	if (ONSOnslaughtGame(Level.Game) == None)
	{
		warn("MutLinkMe: No Onslaught game -- NOT replacing default controller class.");
		return;
	}
	*/
	class'xPawn'.default.ControllerClass = BotClass;
	log("LinkMeServerActor: Default bot class changed to"@BotClass);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
defaultproperties
{
	BotClass = class'xLinkMeBot'
	RemoteRole = ROLE_None
	bHidden = True
}