class HU_ComboSpeed extends HU_ComboBase;

var UTEmitter EmitterB;

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	local UTPawn P;

	Super.GivenTo(NewOwner, bDoNotActivate);

	P = UTPawn(NewOwner);
	if (P != None)
	{
		P.GroundSpeed *= 1.5;
		P.JumpZ *= 1.5;
	}
}


static function float GetAIRating(AIController C)
{

if(C.PlayerReplicationInfo.bHasFlag)
 return 1.0;

if(UTBot(C).IsInState('MoveToGoal') || C.Enemy == None)
return 0.8 + (0.25 - FRand()/2);

return 0.15;

}


//Stolen from UTGameContent.UTJumpBootsEffect
//Rewrite StartEffects() so that we can spawn two emitters, and attach one to each foot
function StartEffects(Pawn ThisPawn)
{
local vector SocketLocation;
local rotator SocketRotation;
local UTPawn UTPawn;

UTPawn = UTPawn(ThisPawn);

if(UTPawn == None || UTPawn.Mesh == None)
return;


  if (UTPawn.Mesh.GetSocketWorldLocationAndRotation(UTPawn.PawnEffectSockets[0], SocketLocation, SocketRotation))
	{
         Emitter = Spawn(class'UTEmitter', UTPawn,, SocketLocation, SocketRotation);
	if (UTPawn.Mesh.bOwnerNoSee)
	  {
	   Emitter.ParticleSystemComponent.SetOwnerNoSee(true);
	  }
	 Emitter.SetBase(UTPawn,, UTPawn.Mesh, UTPawn.PawnEffectSockets[0]);
	 Emitter.SetTemplate(EffectTemplate, true);
	 Emitter.Lifespan = 0.0;
	}
  if (UTPawn.Mesh.GetSocketWorldLocationAndRotation(UTPawn.PawnEffectSockets[1], SocketLocation, SocketRotation))
	{
	EmitterB = Spawn(class'UTEmitter', UTPawn,, SocketLocation, SocketRotation);
	if (UTPawn.Mesh.bOwnerNoSee)
	  {
	   EmitterB.ParticleSystemComponent.SetOwnerNoSee(true);
	  }
	 EmitterB.SetBase(UTPawn,, UTPawn.Mesh, UTPawn.PawnEffectSockets[1]);
	 EmitterB.SetTemplate(EffectTemplate, true);
	 EmitterB.Lifespan = 0.0;
	}
}


function ItemRemovedFromInvManager()
{
	local UTPawn P;

	P = UTPawn(Owner);
	if (P != None)
	{
		P.GroundSpeed /= 1.5;
		P.JumpZ /= 1.5;
	}
Super.ItemRemovedFromInvManager();
}


function StopEffects()
{
 if (Emitter != None)
  {
   Emitter.Destroy();
  }
 if (EmitterB != None)
  {
   EmitterB.Destroy();
  }
}

defaultproperties
{
 PickupMessage="Speed!"//Combo's name    
EffectTemplate=ParticleSystem'HyperUnreal2K4_Cont.SpeedComboEffect'
Keys="FFFF"//4 times forward

}
