class HU_ComboInvisibility extends HU_ComboBase;

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	local UTPawn P;

	Super.GivenTo(NewOwner, bDoNotActivate);

	// boost damage
	P = UTPawn(NewOwner);
	if (P != None)
	{
		P.SetSkin(Material'Pickups.Invis.M_Invis_01');
		P.SetInvisible(true);
	}
}



static function float GetAIRating(AIController C)
{
 if(C.Enemy != None && VSize(C.Enemy.Location - C.Pawn.Location) > 5500.0)
  return 0.6 + (0.25 - FRand()/2); 

 if(UTBot(C).IsSniping() || UTBot(C).IsInState('Defending'))
  return 0.85;

return 0.25;
}


function ItemRemovedFromInvManager()
{
	local UTPawn P;

	P = UTPawn(Owner);
	if (P != None)
	{
		P.SetSkin(None);
		P.SetInvisible(P.default.bIsInvisible);
	}
}

defaultproperties
{
 PickupMessage="Invisible!"    
ProhibedPowerup=class'UTGameContent.UTInvisibility'
Keys="RRLL"
EffectTemplate=None
}
