class HU_ComboBerserk extends HU_ComboBase;


var MaterialInterface OverlayMaterialInstance;
/** particle effect played on vehicle weapons */
var MeshEffect VehicleWeaponEffect;

simulated static function AddWeaponOverlay(UTGameReplicationInfo GRI)
{
	GRI.WeaponOverlays[1] = default.OverlayMaterialInstance;
	GRI.VehicleWeaponEffects[1] = default.VehicleWeaponEffect;
}

/** adds or removes our bonus from the given pawn */
simulated function AdjustPawn(UTPawn P, bool bRemoveBonus)
{
	if (P != None && Role == ROLE_Authority)
	{
		if (bRemoveBonus)
		{
			P.FireRateMultiplier *= 2.0;
		}
		else
		{
			// halve firing time
			P.FireRateMultiplier *= 0.5;
		}
		P.FireRateChanged();
	}
}

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	local UTPawn P;

	Super.GivenTo(NewOwner, bDoNotActivate);

	P = UTPawn(NewOwner);
	if (P != None)
	{
		P.SetWeaponOverlayFlag(1);
		AdjustPawn(P, false);
	}
}


static function float GetAIRating(AIController C)
{
 if(C.Enemy != None && VSize(C.Enemy.Location - C.Pawn.Location) < 2500.0)
  return 0.55 + (0.5 - FRand()); 

 if(!UTBot(C).IsSniping() || UTBot(C).IsInState('Charging'))
  return 0.8;

return 0.12;
}


reliable client function ClientGivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	Super.ClientGivenTo(NewOwner, bDoNotActivate);

	if (Role < ROLE_Authority)
	{
		AdjustPawn(UTPawn(NewOwner), false);
	}
}

function ItemRemovedFromInvManager()
{
	local UTPawn P;

	P = UTPawn(Owner);
	if ( P != None )
	{
		P.ClearWeaponOverlayFlag(1);
		AdjustPawn(P, true);
	}
	SetTimer(0.0, false, 'PlayBerserkFadingSound');
}

simulated event Destroyed()
{
	if (Role < ROLE_Authority)
	{
		AdjustPawn(UTPawn(Owner), true);
	}

	Super.Destroyed();
}

defaultproperties
{
 PickupMessage="Berserk!"    
ProhibedPowerup=class'UTGameContent.UTBerserk'
Keys="FFBB"
EffectTemplate=None
OverlayMaterialInstance=Material'Pickups.Berserk.M_Berserk_Overlay'
VehicleWeaponEffect=(Mesh=StaticMesh'Envy_Effects.Mesh.S_VH_Powerups',Material=MaterialInterface'Envy_Effects.Energy.Materials.M_VH_Beserk')
}
