/* The most useful elements for custom combos are the variables from Keys to ProhibedPowerup and the function GetAIRating()
REMEMBER! Don't forget to add your combo manually into the mutator.
For this, open UTGame\Config\UTHyperUnreal2k4.ini, and where you can see a block of lines
beginning with "ComboConfig=...", just add a new line with your mutator class
ComboConfig=(ComboClass="MyPackage.MyCombo",IsEnabled=true)
*/
class HU_ComboBase extends UTInventory;
//Yeah, extends UTInventory, so you have access to every functions items have.
//A combo spawns when the correct movement key is done and adrenaline is at maximum,
//and destroys if adrenaline reaches 0, or player is dead

var() string Keys;
//Combination of movement keys to activate this combo
//F = forward key , B = backward key, R = rightward key, L = leftward key
//Example: putting Keys="FFBB" would mean that the player has to move twice forward and twice backward to activate this combo
//The amount of key is unlimited. You could put 2 or 15 keys, as you like

var() float AdrenalineDrainRate;
//how fast the adrenaline is dicreased while combo is active.

var() int AdrenalineDrainAmount;
//Amount of adrenaline dicreased while combo is active

var ParticleSystem EffectTemplate;
//A particle emitter spawned and attached to the pawn once the combo is active

var class<Inventory> ProhibedPowerup;
//Item class that a player cannot pickup while the combo is active
//example: berserk combo prevents pawn from picking berserk power-up

var HUAdrenalinfo AInfo;
//The Adrenalinfo manages every players' adrenaline and combos

var UTEmitter Emitter;


function GivenTo( Pawn thisPawn, optional bool bDoNotActivate )
{
Super.GivenTo(ThisPawn, bDoNotActivate);

if(ThisPawn == None)
return;

	if (PickupSound != None)
	{
		ThisPawn.PlaySound( PickupSound );
	}

   StartEffects(ThisPawn); //Create emitters
}



function StartEffects(Pawn ThisPawn)
{
if (EffectTemplate != None && Emitter == None)
	{
		Emitter = Spawn(class'UTEmitter', ThisPawn,, ThisPawn.Location, ThisPawn.Rotation);
			if (ThisPawn.Mesh.bOwnerNoSee)
			{
				Emitter.ParticleSystemComponent.SetOwnerNoSee(true);
			}
			Emitter.SetBase(ThisPawn);
			Emitter.SetTemplate(EffectTemplate, true);
			Emitter.Lifespan = 0.0;
	}
}

function StopEffects()
{
  if (Emitter != None)
  {
   Emitter.Destroy();
  }
}


//GetAIRating tells a bot what should be the best combo he should do, depending on the circumstances
//Called for every enabled combos for the mutator once adrenaline is at maximum
//The higher it is, the better it is for the bot. Maybe don't go over 1.0
static function float GetAIRating(AIController C)
{
return 0.0;
}


function ItemRemovedFromInvManager()
{
StopEffects();
}

simulated event Destroyed()
{
	if (Role == ROLE_Authority)
	{
     StopEffects();
	}

	Super.Destroyed();
}

defaultproperties
{
 bDropOnDisrupt=false
 bDropOnDeath=false
 PickupMessage="Combo" //The name of the combo is this.
 DroppedPickupClass=none
 AdrenalineDrainRate=0.2
 AdrenalineDrainAmount=1 //1 adrenaline dropped 5 times per second
 PickupSound=SoundCue'A_Pickups_Powerups.PowerUps.A_Powerup_UDamage_EndCue'
 EffectTemplate=ParticleSystem'HyperUnreal2K4_Cont.BoosterEffect'
 //this is the booster's effect
}
