class HU_ComboRegen extends HU_ComboBase;

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	Super.GivenTo(NewOwner, bDoNotActivate);

SetTimer(0.9, true, 'AddHealth');
}


static function float GetAIRating(AIController C)
{
if(C.Pawn.Health <= C.Pawn.HealthMax + 25 && C.Pawn.Health >= C.Pawn.HealthMax/4)
return 0.7 + (0.25 - FRand()/2);

if(UTBot(C).IsInState('Defending') || UTBot(C).DefensePoint != None)
return 1.0;

return 0.15;
}

function AddHealth()
{
local UTPawn P;

P = UTPawn(Owner);

if(P == None || P.Health <= 0)
return;

    if (P.Role == ROLE_Authority)
    {
        if ( !P.GiveHealth(5, P.SuperHealthMax) )
			P.ShieldBeltArmor = Min(100,P.ShieldBeltArmor + 5);
    }
}


defaultproperties
{
 PickupMessage="Booster!" //Combo's name   
Keys="BBBB"//4 times backward
AdrenalineDrainRate=0.33
//Particle system already defined in HU_ComboBase
}
