/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeapon_Enforcer extends UTWeap_Enforcer;

var BattleWeaponMagic ActiveBWM;
var int ActiveBWMLevel;
var Material MagicMaterial;
var string MyName; // Determine the name on the server, show it on the client

replication
{
  if (Role == ROLE_Authority)
    MyName, MagicMaterial;
}

// Initialize the weapon
simulated function PostBeginPlay() 
{
  local BattleRPG BRPG;
  Super.PostBeginPlay();
  BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (WorldInfo);  
  if (BRPG != None) BRPG.CreateWeaponMagic (Self, ActiveBWM, ActiveBWMLevel);
  Rename ();
}

function Rename ()
{
  if (ActiveBWM != None) {
    MyName = ActiveBWM.WeaponName (Super.GetHumanReadableName(), ActiveBWMLevel);
  } else {
    MyName = Super.GetHumanReadableName();
  }
}

simulated function String GetHumanReadableName()
{
  return MyName;
}

simulated function Tick(float DeltaTime)
{
  if (MagicMaterial != None) {
    SetSkin (MagicMaterial);
  }
}

simulated function SetSkin(Material NewMaterial)
{
	local int i,Cnt;
	local UTPawn P;
	Super(UTWeapon).SetSkin(NewMaterial); // Super.Super

	if ( LeftMesh != none && NewMaterial == None )	// Clear the materials
	{
		if ( default.Mesh.Materials.Length > 0 )
		{
			Cnt = Default.Mesh.Materials.Length;
			for (i=0;i<Cnt;i++)
			{
				LeftMesh.SetMaterial( i, Default.Mesh.GetMaterial(i) );
			}
		}
		else if (LeftMesh.Materials.Length > 0)
		{
			Cnt = LeftMesh.Materials.Length;
			for ( i=0; i < Cnt; i++ )
			{
				LeftMesh.SetMaterial(i,none);
			}
		}
	}
	else if( LeftMesh != none )
	{
		if ( default.LeftMesh.Materials.Length > 0 || Leftmesh.GetNumElements() > 0 )
		{
			Cnt = default.LeftMesh.Materials.Length > 0 ? default.LeftMesh.Materials.Length : LeftMesh.GetNumElements();
			for ( i=0; i < Cnt; i++ )
			{
				LeftMesh.SetMaterial(i,NewMaterial);
			}
		}
	}

	if( NewMaterial==none )
	{
		P = UTPawn(Instigator);

			WeaponMaterialInstance = MaterialInstanceConstant(Mesh.Materials[0]);
			if(WeaponMaterialInstance == none)
			{
				WeaponMaterialInstance = Mesh.CreateAndSetMaterialInstanceConstant(0);
			}

			// if we have a leftmesh
			if( LeftMesh != none )
			{
				LeftWeaponMaterialInstance = MaterialInstanceConstant(LeftMesh.Materials[0]);
				if(LeftWeaponMaterialInstance == none)
				{
					LeftWeaponMaterialInstance = LeftMesh.CreateAndSetMaterialInstanceConstant(0);
				}
			}
		if(P != none)
		{
			if(P.GetTeamNum() == 1) // blue
			{
				WeaponMaterialInstance.SetVectorParameterValue('Enforcer_Diffuse',MakeLinearColor(0,0.1,2,1));
				WeaponMaterialInstance.SetVectorParameterValue('Enforcer_Spec',MakeLinearColor(0,0,7,1));
				if( LeftWeaponMaterialInstance != none )
				{
					LeftWeaponMaterialInstance.SetVectorParameterValue('Enforcer_Diffuse',MakeLinearColor(0,0.1,2,1));
					LeftWeaponMaterialInstance.SetVectorParameterValue('Enforcer_Spec',MakeLinearColor(0,0,7,1));
				}
			}
			else
			{
				WeaponMaterialInstance.SetVectorParameterValue('Enforcer_Diffuse',MakeLinearColor(1.0,0.0,0.0,1.0));
				WeaponMaterialInstance.SetVectorParameterValue('Enforcer_Spec',MakeLinearColor(7.0,0.0,0.0,1.0));
				if( LeftWeaponMaterialInstance != none )
				{
					LeftWeaponMaterialInstance.SetVectorParameterValue('Enforcer_Diffuse',MakeLinearColor(1.0,0.0,0.0,1.0));
					LeftWeaponMaterialInstance.SetVectorParameterValue('Enforcer_Spec',MakeLinearColor(7.0,0.0,0.0,1.0));
				}
			}
		}
	}
}

defaultproperties
{
}