/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic extends Object config (BattleRPG); 

var config string MagicName;
var config int MagicMaxLevel;
var bool bPositiveMagic; // Not configurable
var int DamageChangePercentage;
var Material MagicMaterial;

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function DamageFromOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InstigatedByPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function AddMagic (UTPawn P, int Level);
function RemoveMagic (UTPawn P, int Level);
function RapidServerTimer (UTPawn P, int Level);
function ServerTimer (UTPawn P, int Level);
function ModifyProjectile (Projectile PR, int Level);

function bool AllowedFor (Weapon w)
{
  return true;
}

function string MagicDescription (int Level)
{
  if (bPositiveMagic) {
    return MagicName@"+"$Level;
  } else {
    return MagicName@"-"$Level;
  }
}

function string WeaponName (string RawName, int Level) 
{
  if (DamageChangePercentage != 0) {
    if (bPositiveMagic) {
      return RawName@"of"@MagicDescription (Level)@"(damage +"$(Level*DamageChangePercentage)$"%)";
    } else {
      return RawName@"of"@MagicDescription (Level)@"(damage -"$(Level*DamageChangePercentage)$"%)";
    }
  } else {
    return RawName@"of"@MagicDescription (Level);
  }
}


defaultproperties
{
  MagicName = "Magicname";
  MagicMaxLevel = 10;
  MagicMaterial = None;
  bPositiveMagic = true;
  DamageChangePercentage = 0;
}