/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.

    This file also contains code that is derived from code which is
    Copyright 1998-2007 Epic Games, Inc. All Rights Reserved. That part 
    of the code is covered by the Epic license and not by the GPL.
*/

`include (BattleRPG/Classes/BattleRPG.uci) 

class BattleScoreboardPanelSTD extends UTScoreboardPanel;

// Developped in BattleScoreboardPanelCTF.uc then copied to the other scoreboards

// Derived from UTScoreboarPanel.uc
function DrawPlayerName2 (UTPlayerReplicationInfo PRI, float NameOfst, float NameClipX, out float YPos, int FontIndex, float FontScale, bool bIncludeClan, int MiscFontIndex)
{
  local float XL, YL;
  local string Spot;

  Spot = bIncludeClan ? GetPlayerNameStr(PRI) : GetClanTagStr(PRI)$GetPlayerNameStr(PRI);
  if (MiscFontIndex < 0) {
    StrLen (Spot $ class'BattleStaticFunctions'.static.GetExtraRightName (PRI), XL, YL, FontIndex, FontScale * MainPerc);
  } else {
    StrLen (Spot, XL, YL, FontIndex, FontScale * MainPerc);
  }
  YL = Fonts[FontIndex].CharHeight * FontScale * MainPerc;

  if ( XL > (NameClipX - NameOfst) && !bIncludeClan )
  {
    Spot = GetPlayerNameStr(PRI);
  }

  if (MiscFontIndex < 0) Spot = Spot $ class'BattleStaticFunctions'.static.GetExtraRightName (PRI);

  DrawString( Spot, NameOfst, YPos, FontIndex, FontScale * MainPerc);

  YPos += YL;
}

// Derived from UTScoreboarPanel.uc
function DrawPRI (int PIndex, UTPlayerReplicationInfo PRI, float CellHeight, int FontIndex, int ClanTagFontIndex, int MiscFontIndex, float FontScale, out float YPos)
{
  local float NameOfst, NameClipX;

  // Set the default Drawing Color
  DrawHighlight(PRI, YPos, CellHeight, FontScale);

  if ( PRI == UTUIScene(GetScene()).GetPRIOwner() )
  {
    Canvas.DrawColor = class'UTHUD'.default.GoldColor;
  }
  else
  {
    Canvas.DrawColor = class'HUD'.default.WhiteColor;
  }

  // Line up the names with the header.
  NameOfst = Canvas.ClipX * HeaderXPct;

  YPos += (HighlightPad*ResolutionScale);

  Canvas.DrawColor.A = 105;
  DrawClanTag(PRI, NameOfst, YPos, ClanTagFontIndex, FontScale);

  // Draw the player's Score so we can see how much room we have to draw the name
  if ( PRI == UTUIScene(GetScene()).GetPRIOwner() )
  {
    Canvas.DrawColor.A = 255;
  }
  else
  {
    Canvas.DrawColor.A = 128;
  }
  if ( !PRI.bFromPreviousLevel || PRI.WorldInfo.IsInSeamlessTravel() ||
    (PlayerOwner != None && PlayerOwner.PlayerReplicationInfo != None && PlayerOwner.PlayerReplicationInfo.bFromPreviousLevel) )
  {
    NameClipX = DrawScore(PRI, YPos, FontIndex, FontScale);
  }
  else
  {
    NameClipX = Canvas.ClipX;
  }

  // Draw the Player's Name and position on the team - NOTE it doesn't increment YPos
  if (bDrawPlayerNum)
  {
    DrawPlayerNum(PRI, PIndex, YPos, FontIndex, FontScale);
  }

  DrawPlayerName2(PRI, NameOfst, NameClipX, YPos, FontIndex, FontScale, (ClanTagFontIndex >= 0), MiscFontIndex);

  Canvas.DrawColor.A = 105;
  DrawMisc(PRI, NameOfst, YPos, MiscFontIndex, FontScale);

  YPos += (HighlightPad*ResolutionScale);
}

function string GetRightMisc(UTPlayerReplicationInfo PRI)
{
  return Super.GetRightMisc(PRI)$"   "$
    class'BattleStaticFunctions'.static.GetExtraRightMisc (PRI, int(GetPlayerDeaths(PRI)), int(GetPlayerScore(PRI)), false);
}

defaultproperties
{
`if(`isdefined(BRPG_Build4GaltanorsInvasion))
  AssociatedTeamIndex=0
`endif
}