/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleHUDTeam extends UTTeamHUD;

function DisplayHit(vector HitDir, int Damage, class<DamageType> damageType)
{
  Super.DisplayHit (HitDir, Damage, damageType);
  class'BattleStaticFunctions'.static.BattleEnhanceHUD (self);
}

function DisplayAmmo(UTWeapon Weapon)
{
  Super.DisplayAmmo (Weapon); 
  class'BattleStaticFunctions'.static.BattleEnhanceHUD (self);
}

function DisplayScoring()
{
  Super.DisplayScoring();
  class'BattleStaticFunctions'.static.BattleEnhanceHUD (self);
}

function DisplayFragCount(vector2d POS)
{
  Super.DisplayFragCount (POS);
  class'BattleStaticFunctions'.static.BattleEnhanceHUD (self);
}

function DisplayClock()
{
  Super.DisplayClock();
  class'BattleStaticFunctions'.static.BattleEnhanceHUD (self);
}

exec function BRPG (string CommandLine)
{
  ServerExecBRPG (CommandLine);
}

reliable server function ServerExecBRPG (string CommandLine)
{
  local BattlePlayerController BPC;

  if (self.UTOwnerPRI != None && self.UTOwnerPRI.Owner != None) {
    BPC = BattlePlayerController (self.UTOwnerPRI.Owner);
    BPC.ServerExecBRPG (CommandLine);
  }
}

defaultproperties
{
  ScoreboardSceneTemplate=UTUIScene_TeamScoreboard'BattleRPGContent.sbTeamDM'
  Name="Default__BattleHUDTeam"
}