/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_ManaRegen extends BattleAbility config (BattleRPG);

var int CountDown;

function ServerTimer (UTPawn P, int Level)
{
  local PlayerController PC;
  local BPRIDATA BD;

  if (CountDown > 0) {
    CountDown--;
    return;
  } else {
    Countdown = 3;
  }

  if (P != None && P.Owner != None) {
    PC = PlayerController (P.Owner);
    if (PC != None && PC.PlayerReplicationInfo != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.Mana <= 100) {
        BD.Mana += Level; // Make Mana harder to collect for Warfare
        if (BD.Mana > 100) BD.Mana = 100;
        class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
      }
    }
  }
}

defaultproperties
{
  AbilityName = "Mana Regeneration";
  AbilityDescription = "Regenerates 1 Mana per level per 3 seconds up to 100 Mana.";
  AbilityMaxLevel = 3;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}