/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_DodgeJumping extends BattleAbility config (BattleRPG) dependson(BattleStaticFunctions);

function ServerModifyPlayer (UTPawn P, int Level)
{
  local PlayerController PC;
  local BPRIDATA BD;

  PC = PlayerController (P.Owner);
  if (PC!=None) {
    BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
    BD.bAllowDodgeJumping = true;
    class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
  }
}


defaultproperties
{
  AbilityName = "Dodge Jumping";
  AbilityDescription = "Enables UT2004 style dodge jumping.";
  AbilityMaxLevel = 1;
  AbilityLevel1Cost = 5;
  AbilityCostIncreasePerLevel = 0;
}