/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_AmmoRegen extends BattleAbility config (BattleRPG);

var float AmmoToAdd; // Generic, weapons use each others slack

function ServerTimer (UTPawn P, int Level)
{
  local UTWeapon UTW;

  ForEach P.InvManager.InventoryActors (class'UTWeapon', UTW) {
    if (!UTW.bSuperWeapon && class'BattleStaticFunctions'.static.HasWEAP (UTW)) {
      AmmoToAdd += Level*0.005*UTW.default.MaxAmmoCount;
      if (AmmoToAdd > 1.0) {
        UTW.AddAmmo (int (AmmoToAdd)); // Automatically reduced by UT3
        AmmoToAdd -= int (AmmoToAdd);
      }
    }
  }
}

defaultproperties
{
  AbilityName = "Ammo Regeneration";
  AbilityDescription = "Regenerates ammo for your weapons at approximately 0.5% per level per second.";
  AbilityMaxLevel = 5;
  AbilityLevel1Cost = 5;
  AbilityCostIncreasePerLevel = 5;
}