/**
 *	Unreal Game Plus Packages
 *
 *	Copyright (c) 2007 Rodney Powers
 */
`include (BattleRPG/Classes/BattleRPG.uci)

`if(`isdefined(BRPG_Build4UT3Invasion))
	class BRPGExt_UT3InvasionRpgScoreboardExtension extends UTPScoreboardExtension;
`else
	class BRPGExt_UT3InvasionRpgScoreboardExtension extends Object;
`endif

`if(`isdefined(BRPG_Build4UT3Invasion))

////////////////////////////////////////////////////////////////////////////////

static function Apply(UTPScoreboardPanel scoreboard) {
	local UTPScoreboardPanel.CaptionParameters PlayerUniqueIdCaption;
	local UTPScoreboardPanel.CaptionParameters PlayerNameCaption;
	local UTPScoreboardPanel.CaptionParameters PlayerPingCaption;
	local int i;
	local int nameIndex;
	local int pingIndex;

	PlayerUniqueIdCaption.Name = "RpgInformation";
	PlayerUniqueIdCaption.ParseCaption = true;
	PlayerUniqueIdCaption.Caption = "Level: %PlayerRpgLevel% (%PlayerXp%/%PlayerNeededXp%)";
	PlayerUniqueIdCaption.HighlightCurrentPlayer = true;

	// Run through all the player caption styles and find the ones that have
	// both a player name and ping caption. We're assuming the ping is on a
	// separate line that we can highjack underneath the player name to display
	// our new caption.
	for (i = 0; i < scoreboard.PlayerCaptionStyles.Length; ++i) {
		nameIndex = scoreboard.PlayerCaptionStyles[i].CaptionList.Find('name', "name");

		if (nameIndex < 0) {
			continue;
		}

		pingIndex = scoreboard.PlayerCaptionStyles[i].CaptionList.Find('name', "Ping");

		if (pingIndex < 0) {
			continue;
		}

		PlayerNameCaption = scoreboard.PlayerCaptionStyles[i].CaptionList[nameIndex];
		PlayerPingCaption = scoreboard.PlayerCaptionStyles[i].CaptionList[pingIndex];

		// Align the caption to be left with the player name, and top with the
		// ping text. Then apply all the ping attributes so it looks like that
		// text.
		PlayerUniqueIdCaption.Position.X = PlayerNameCaption.Position.X;
		PlayerUniqueIdCaption.Position.Y = PlayerPingCaption.Position.Y;
		PlayerUniqueIdCaption.Dimensions.X = PlayerNameCaption.Dimensions.X;
		PlayerUniqueIdCaption.Dimensions.Y = PlayerPingCaption.Dimensions.Y;
		PlayerUniqueIdCaption.VerticalAlignment = PlayerPingCaption.VerticalAlignment;
		PlayerUniqueIdCaption.FontSize = PlayerPingCaption.FontSize;
		PlayerUniqueIdCaption.ColorOp = PlayerPingCaption.ColorOp;
		PlayerUniqueIdCaption.Color = PlayerPingCaption.Color;

		// Finally, insert our new caption into the list of styles.
		scoreboard.PlayerCaptionStyles[i].CaptionList[scoreboard.PlayerCaptionStyles[i].CaptionList.Length] = PlayerUniqueIdCaption;
	}
}

////////////////////////////////////////////////////////////////////////////////

static function ParsePlayerScoreboardText(out String text, PlayerReplicationInfo PRI, int rank) {
	text = Repl(text, "%PlayerRpgLevel%", BattlePRIInvasion(PRI).Level);
	text = Repl(text, "%PlayerNeededXp%", BattlePRIInvasion(PRI).NeededXP);
	text = Repl(text, "%PlayerXp%", BattlePRIInvasion(PRI).XP);
}

////////////////////////////////////////////////////////////////////////////////

`endif

DefaultProperties
{

}