/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeapon_Stinger extends UTWeap_Stinger;

var BattleWeaponMagic ActiveBWM;
var int ActiveBWMLevel;
var Material MagicMaterial;
var string MyName; // Determine the name on the server, show it on the client

replication
{
  if (Role == ROLE_Authority)
    MyName, MagicMaterial;
}

// Initialize the weapon
simulated function PostBeginPlay() 
{
  local BattleRPG BRPG;
  Super.PostBeginPlay();
  BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (WorldInfo);  
  if (BRPG != None) BRPG.CreateWeaponMagic (Self, ActiveBWM, ActiveBWMLevel);
  Rename ();
}

function Rename ()
{
  if (ActiveBWM != None) {
    MyName = ActiveBWM.WeaponName (Super.GetHumanReadableName(), ActiveBWMLevel);
  } else {
    MyName = Super.GetHumanReadableName();
  }
}

simulated function String GetHumanReadableName()
{
  return MyName;
}

simulated function Tick(float DeltaTime)
{
  if (MagicMaterial != None) {
    SetSkin (MagicMaterial);
  }
}

simulated function Projectile ProjectileFire()
{
  local Projectile PR;

  PR = Super.ProjectileFire();

  if (ActiveBWM != None && PR != None) {
    ActiveBWM.ModifyProjectile (PR, ActiveBWMLevel);
  }

  return PR;
}

defaultproperties
{
  WeaponProjectiles(1)=Class'BattleProjectile_StingerShard'
}