/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Slowmotion extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  if (ClassIsChildOf (W.Class, class'UTWeap_Enforcer')) return false;
  if (ClassIsChildOf (W.Class, class'UTWeap_ImpactHammer')) return false;
  if (ClassIsChildOf (W.Class, class'UTWeap_SniperRifle')) return false;
  return true;
}


function ModifyProjectile (Projectile PR, int Level)
{
  if (Level > 3) Level = 3; // Leave at least 10% speed
  if (PR.Speed == PR.default.Speed && PR.MaxSpeed == PR.default.MaxSpeed) {
    PR.Speed *= 1.0 - 0.3 * Level;
	PR.MaxSpeed *= 1.0 - 0.3 * Level;
	PR.Velocity *= 1.0 - 0.3 * Level;
  }
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * (1.0 - Level * 0.05); // It's negative magic, so we do some less damage as well
}

defaultproperties
{
  MagicName = "Slow Motion";
  MagicMaxLevel = 3;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Harm';
  bPositiveMagic = false;
  DamageChangePercentage = 3;
}