/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactInstant_Bonus extends BattleArtifactInstant config (BattleRPG);

function ActivateInstantArtifact (UTPawn P)
{
  local array< class<Inventory> > BonusInventory;
  local int i;  

  if (P.Health < 300) P.Health = 300;
  BonusInventory.Length = 10;
  BonusInventory[0] = Class'BattleRPG.BattleWeapon_Enforcer';
  BonusInventory[1] = Class'BattleRPG.BattleWeapon_ImpactHammer';
  BonusInventory[2] = Class'BattleRPG.BattleWeapon_RocketLauncher';
  BonusInventory[3] = Class'BattleRPG.BattleWeapon_Avril';
  BonusInventory[4] = Class'BattleRPG.BattleWeapon_BioRifle';
  BonusInventory[5] = Class'BattleRPG.BattleWeapon_FlakCannon';
  BonusInventory[6] = Class'BattleRPG.BattleWeapon_LinkGun';
  BonusInventory[7] = Class'BattleRPG.BattleWeapon_ShockRifle';
  BonusInventory[8] = Class'BattleRPG.BattleWeapon_SniperRifle';
  BonusInventory[9] = Class'BattleRPG.BattleWeapon_Stinger';
  for (i=0; i<BonusInventory.Length; i++) {
    if (P.FindInventoryType(BonusInventory[i]) == None) {
      P.CreateInventory(BonusInventory[i], (i > 0));
    }
  } 
  class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "Some people have everything");
}

defaultproperties
{
  ArtifactName = "Bonus";
  ManaUsage = 100;
}