/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_VehicleVampirism extends BattleAbility config (BattleRPG);

function LLDamageToOtherPawn (Pawn P, int Level, int OriginalDamage, out int Damage, Pawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local int Bonus;
  local int AbilityMaxGainedHealth;
  Bonus = int (Damage * 0.05 * Level);

  if (UTVehicle (P) == None) return;

  // Check if InjuredPawn has enough Health left, otherwise reduce the bonus.
  if (InjuredPawn!=None) {
    if (Damage > InjuredPawn.Health) Bonus = int (InjuredPawn.Health * 0.05 * Level);
  }

  AbilityMaxGainedHealth = P.HealthMax + 100;
  if (P.Health < AbilityMaxGainedHealth) {
    P.Health += Bonus;
    if (P.Health > AbilityMaxGainedHealth) P.Health = AbilityMaxGainedHealth;
  }  
}

defaultproperties
{
  AbilityName = "Vehicle Vampirism";
  AbilityDescription = "Per level 5% of the damage your vehicle does is added to your vehicles health, up to 100 above the starting health.";
  AbilityMaxLevel = 5;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}