/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeapon_RocketLauncher extends UTWeap_RocketLauncher;

var BattleWeaponMagic ActiveBWM;
var int ActiveBWMLevel;
var Material MagicMaterial;
var string MyName; // Determine the name on the server, show it on the client

replication
{
  if (Role == ROLE_Authority)
    MyName, MagicMaterial;
}

// Initialize the weapon
simulated function PostBeginPlay() 
{
  local BattleRPG BRPG;
  Super.PostBeginPlay();
  BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (WorldInfo);  
  if (BRPG != None) BRPG.CreateWeaponMagic (Self, ActiveBWM, ActiveBWMLevel);
  Rename ();
}

function Rename ()
{
  if (ActiveBWM != None) {
    MyName = ActiveBWM.WeaponName (Super.GetHumanReadableName(), ActiveBWMLevel);
  } else {
    MyName = Super.GetHumanReadableName();
  }
}

simulated function String GetHumanReadableName()
{
  return MyName;
}

simulated function Tick(float DeltaTime)
{
  if (MagicMaterial != None) {
    SetSkin (MagicMaterial);
  }
}

simulated function Projectile ProjectileFire()
{
  local Projectile PR;

  PR = Super.ProjectileFire();

  if (ActiveBWM != None && PR != None) {
    ActiveBWM.ModifyProjectile (PR, ActiveBWMLevel);
  }

  return PR;
}

function FireLoad()
{
	local int i,j,k;
	local vector SpreadVector;
	local rotator Aim;
	local float theta;
   	local vector Firelocation, RealStartLoc, X,Y,Z;
	local Projectile	SpawnedProjectile;
	local UTProj_LoadedRocket FiredRockets[4];
	local bool bCurl;
	local byte FlockIndex;

	// this is to get the location of the "popped up" rocket launcher tube
	if(LoadedShotCount == 1 && CurrentFireMode == 1)
	{
		RealStartLoc = GetPhysicalFireStartLoc() + vect(0,0,3);
	}
	else
	{
		// this is the location where the projectile is spawned
		RealStartLoc = GetPhysicalFireStartLoc();
	}


	Aim = GetAdjustedAim( RealStartLoc );			// get fire aim direction

	GetViewAxes(X,Y,Z);

	for (i = 0; i < LoadedShotCount; i++)
	{
		if (LoadedFireMode == RFM_Grenades || LoadedFireMode == RFM_Spread)
		{
			// Give them some gradual spread.
			theta = GetSpreadDist() * PI / 32768.0 * (i - float(LoadedShotCount - 1) / 2.0);
			SpreadVector.X = Cos(theta);
			SpreadVector.Y = Sin(theta);
			SpreadVector.Z = 0.0;

			SpawnedProjectile = Spawn(GetProjectileClass(),,, RealStartLoc, Rotator(SpreadVector >> Aim));

            if (ActiveBWM != None && SpawnedProjectile != None) {
              ActiveBWM.ModifyProjectile (SpawnedProjectile, ActiveBWMLevel);
            }

			if ( SpawnedProjectile != None )
			{
				if (LoadedFireMode == RFM_Grenades)
				{
					UTProjectile(SpawnedProjectile).TossZ += (frand() * 200 - 100);
				}
				SpawnedProjectile.Init(SpreadVector >> Aim);
			}
		}
		else
		{
			Firelocation = RealStartLoc - 2 * (       (Sin(i * 2 * PI / MaxLoadCount) * 8 - 7) * Y - (Cos(i * 2 * PI / MaxLoadCount) * 8 - 7) * Z    ) - X * 8 * FRand();
			SpawnedProjectile = Spawn(GetProjectileClass(),,, FireLocation, Aim);

            if (ActiveBWM != None && SpawnedProjectile != None) {
              ActiveBWM.ModifyProjectile (SpawnedProjectile, ActiveBWMLevel);
            }

			if ( SpawnedProjectile != None )
			{
				SpawnedProjectile.Init(vector(Aim));
				FiredRockets[i] = UTProj_LoadedRocket(SpawnedProjectile);
			}
		}

		if (LoadedFireMode != RFM_Grenades && bLockedOnTarget && UTProj_SeekingRocket(SpawnedProjectile) != None)
		{
			UTProj_SeekingRocket(SpawnedProjectile).Seeking = LockedTarget;
		}
	}

	// Initialize the rockets so they flock towards each other
	if ( !bLockedOnTarget && (LoadedFireMode == RFM_Spiral) )
	{
		FlockIndex++;
		bCurl = false;

		// To get crazy flying, we tell each projectile in the flock about the others.
		for ( i = 0; i < LoadedShotCount; i++ )
		{
			if ( FiredRockets[i] != None )
			{
				FiredRockets[i].bCurl = bCurl;
				FiredRockets[i].FlockIndex = FlockIndex;

				j=0;
				for ( k=0; k<LoadedShotCount; k++ )
				{
					if ( (i != k) && (FiredRockets[k] != None) )
					{
						FiredRockets[i].Flock[j] = FiredRockets[k];
						j++;
					}
				}
				bCurl = !bCurl;
				if ( WorldInfo.NetMode != NM_DedicatedServer )
				{
					FiredRockets[i].SetTimer(0.1, true, 'FlockTimer');
				}
			}
		}
	}
}

defaultproperties
{
  SeekingRocketClass=Class'BattleProjectile_Rocket'
  LoadedRocketClass=Class'BattleProjectile_Rocket'
  WeaponProjectiles(0)=Class'BattleProjectile_Rocket'
  WeaponProjectiles(1)=Class'BattleProjectile_Rocket'
}