/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Quantum_InvItem extends Inventory;

var Controller InstigatorController; // Server
var int Level; // Server
var bool bShownMessage; // Client
var bool bChangedSettings; // Client


simulated function PostBeginPlay()
{
  super.PostBeginPlay();
  if (Role == ROLE_Authority) {
    SetTimer (0.1, True, 'Timer');
  }
}

simulated event Destroyed()
{
  local Pawn P;
  local BattlePlayerController BPC;

  if (Role == ROLE_Authority && Pawn(Owner) != None) {
    P = Pawn (Owner);
    if (P != None) {
      P.CustomTimeDilation = 1.0;
    }
    foreach WorldInfo.AllControllers(class'BattlePlayerController', BPC)
    {
      BPC.Speedup (P);
    }
  }
  Super.Destroyed();
}

function ClientServerSlowdown (Pawn P, int TheLevel)
{
  local BattlePlayerController BPC;

  if (P != None) {
    P.CustomTimeDilation = 0.50 - 0.05 * Min (5, TheLevel);
  }
  foreach WorldInfo.AllControllers(class'BattlePlayerController', BPC)
  {
    BPC.Slowdown (P, TheLevel);
  }
}

simulated function Timer()
{
  if (Owner == None) return;

  if (Role == ROLE_Authority && !bChangedSettings) {
    if (Owner == None) {
      Destroy();
      return;
    }
    ClientServerSlowdown (Pawn (Owner), Level);
    bChangedSettings = true;
  }

  if (Role == ROLE_Authority) {
    if (!bShownMessage) {
      if (InstigatorController != None) {
        class'BattleStaticFunctions'.static.Message2Pawn (UTPawn(Owner), "posionedfrom", "You have been hit with Quantum magic by"@InstigatorController.PlayerReplicationInfo.PlayerName);
      } else {
        class'BattleStaticFunctions'.static.Message2Pawn (UTPawn(Owner), "posionedfrom", "You have been hit with Quantum magic by someone");
      }
      bShownMessage = true;
    }    
  }
}

defaultproperties
{
}