/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Harm extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true; // Allow it for everything
}

function DamageFromOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InstigatedByPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  if (Damage > 0) {
    Damage = Damage * (1.0 + Level * 0.2);
    if (Damage < 10) Damage = 10;
  }
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * (1.0 - Level * 0.05); // It's negative magic, so we do some less damage as well
}

defaultproperties
{
  MagicName = "Harm";
  MagicMaxLevel = 10;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Harm';
  bPositiveMagic = false;
  DamageChangePercentage = 5;
}