/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

// Need to experiment with leaving the UTPlayerController intact and using custom ReplicationInfo with NotifyLogin instead.
`if(`isdefined(BRPG_BuildRegular))  
  class BattlePlayerController extends UTPlayerController dependson(BattleRPG, BattlePersistentPlayerDatabase);
`endif
`if(`isdefined(BRPG_Build4UT3Invasion))
  class BattlePlayerController extends InvasionPlayerController dependson(BattleRPG, BattlePersistentPlayerDatabase);
`endif
`if(`isdefined(BRPG_Build4GaltanorsInvasion))
  class BattlePlayerController extends UTPlayerController dependson(BattleRPG, BattlePersistentPlayerDatabase);
`endif

// Client side data.
var BattleInteraction BI;
var BattleMainMenu BMM;
var string PanelAbility;
var string PanelAbilityDescription;
var string PanelStatPoints;
var string PanelAbilityList;
var int Countdown;
var int DelayedUpdate;
var array<BattleAbility> AvailableAbilities;
var bool AfterLocalDataInitialized;
var int UICurrentAbility;
var bool MenuVisible;
var int ComboCtr;

// Server side data.
var bool bDrainingArtifactActive;
var class<BattleWeaponMagic> LastActiveWeaponMagic;
var int LastActiveWeaponMagicLevel;
var class<Inventory> LastActiveWeapon;
var float CallTimeStamp;
var int CallCount;

// Server side data which gets replicated to the client.
var DynamicAbilityWrapper ReplicatedDynamicAbilities[100]; // Static array since dynamic arrays do not get replicated.
var int ReplicatedDynamicAbilitiesLength;
var int PlayerAbilityLevels[100];
var int PlayerNextAbilitiesCost[100];
var int SelectedArtifact;  // Index in BattleGenInvItem4Pawns.ActiveArtifacts so BattleRPG remembers what artifact the player had when (s)he dies
var string SelectedArtifactName;
var string SelectedArtifactCost;
var bool LocalDataInitialized;
var int RPGDollarsPerLevel;

replication {
  if (Role == ROLE_Authority)
    ReplicatedDynamicAbilities, ReplicatedDynamicAbilitiesLength, PlayerAbilityLevels, PlayerNextAbilitiesCost,
    SelectedArtifact, SelectedArtifactName, SelectedArtifactCost,
    LocalDataInitialized, RPGDollarsPerLevel;
}

`if(`isdefined(BRPG_DebugCheats))  
function BroadcastCheat (string Type)
{
  local Controller C;
  
  foreach WorldInfo.AllControllers(Class'Controller', C) {
    if (PlayerController(C) != None) {
      class'BattleStaticFunctions'.static.Message2PC (PlayerController(C), "cheat", "Player"@PlayerReplicationInfo.PlayerName@"used debug cheat"@Type);
    }
  }
}
`endif  


function ServerExecBRPG (string CommandLine)
{
`if(`isdefined(BRPG_DebugCheats))  
  local BPRIDATA BD;
  local Actor HitActor;
  local vector HitNormal, HitLocation;
  local vector ViewLocation;
  local rotator ViewRotation;
`endif  

  if (LimitClientCallSpeed()) return;

  if (CommandLine == "use artifact") {
    UseArtifact ();
  } else if (CommandLine == "first artifact") {
    FirstArtifact ();
  } else if (CommandLine == "prev artifact") {
    PrevArtifact ();
  } else if (CommandLine == "next artifact") {
    NextArtifact ();

`if(`isdefined(BRPG_DebugCheats))  // For testing and debugging (don't bother to do all == None checks here)
  } else if (CommandLine == "test reset") {
    UTPawn(Pawn).WeaponOverlayFlags = 0;
    UTWeapon(UTPawn(Pawn).Weapon).SetWeaponOverlayFlags (UTPawn (Pawn));
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (None);
    if (UTPawn(Pawn) != None) UTPawn(Pawn).SetOverlayMaterial (None);
    SetCameraMode('FirstPerson');
	Self.ResetCameraMode();
	if (Pawn != None) SetViewTarget(Pawn);
	else SetViewtarget(Self);
	FixFOV();
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test teleport") {
	GetPlayerViewPoint (ViewLocation, ViewRotation);
	HitActor = Trace (HitLocation, HitNormal, ViewLocation + 1000000 * vector(ViewRotation), ViewLocation, true);
	if (HitActor != None) HitLocation += HitNormal * 4.0;
	ViewTarget.SetLocation (HitLocation);
    BroadcastCheat (CommandLine);
	
  } else if (CommandLine == "test 3rd") {
    SetCameraMode('ThirdPerson');
	FixFOV();
    BroadcastCheat (CommandLine);
	
  } else if (CommandLine == "test skin 1") {
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'EngineMaterials.DefaultMaterial');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 2") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Orange');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 3") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Gore');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 4") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Blood');
    BroadcastCheat (CommandLine);
	
  } else if (CommandLine == "test skin 5") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Example');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 6") { // pawn + weapon
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_LiquidGold');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 7") {
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_LiquidBlue');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 8") {
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_LiquidGreen');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 9") {
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_LiquidRed');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 10") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_BioGreen');
    BroadcastCheat (CommandLine);
	
  } else if (CommandLine == "test skin 11") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_BioRed');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 12") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'PICKUPS.Invis.M_Invis_01');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 13") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Quick');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 14") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Protection');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 15") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Infinity');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test skin 16") { 
	if (UTPawn(Pawn) != None) UTPawn(Pawn).SetSkin (Material'BattleRPGContent.Materials.MT_Harm');
    BroadcastCheat (CommandLine);

  } else if (CommandLine == "test mana") { 
    BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
    BD.Mana += 10000;
    class'BattleStaticFunctions'.static.WriteBPRI (PlayerReplicationInfo, BD);    
    BroadcastCheat ("Mana +10000");

  } else if (CommandLine == "test level") { 
    BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
    BD.Level += 1000;
    class'BattleStaticFunctions'.static.WriteBPRI (PlayerReplicationInfo, BD);    
    BroadcastCheat ("Level +1000");
        
`endif  
  }
}

function int PlayerAbilityLevel (int i)
{
  return PlayerAbilityLevels[i]; // Prevent "Error, Context expression: Variable is too large (400 bytes, 255 max)"
}

function int PlayerNextAbilityCost (int i)
{
  return PlayerNextAbilitiesCost[i]; // Prevent "Error, Context expression: Variable is too large (400 bytes, 255 max)"
}

function bool LimitClientCallSpeed () // Tip from Shambler against exploits
{
  if (WorldInfo.TimeSeconds - CallTimeStamp < 2) {
    if (++CallCount > 15) return true; // Don't allow > 15 calls in < 2 seconds
  } else {
    // Start a new measurement cycle
    CallTimeStamp = WorldInfo.TimeSeconds;
    CallCount = 0;
  }
  return false;
}

function FirstArtifact ()
{
  local BattleGenInvItem4Pawns BGI;

  if (Pawn != None) {
    BGI = BattleGenInvItem4Pawns (Pawn.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI != None) {
      SelectedArtifact = 0;
      SelectedArtifactName = BGI.GetArtifact (SelectedArtifact).ArtifactDescription();
      SelectedArtifactCost = BGI.GetArtifact (SelectedArtifact).ArtifactCostDescription();
    }
  }
}

reliable server function PrevArtifact ()
{
  local BattleGenInvItem4Pawns BGI;

  if (LimitClientCallSpeed() || bDrainingArtifactActive) return;
  if (Pawn != None) {
    BGI = BattleGenInvItem4Pawns (Pawn.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI != None) {
      if (BGI.ActiveArtifactsLength > 0) {
        SelectedArtifact--;
        if (SelectedArtifact == -1) SelectedArtifact = BGI.ActiveArtifactsLength - 1;
      }
      SelectedArtifactName = BGI.GetArtifact (SelectedArtifact).ArtifactDescription();
      SelectedArtifactCost = BGI.GetArtifact (SelectedArtifact).ArtifactCostDescription();
    }
  }
}

reliable server function NextArtifact ()
{
  local BattleGenInvItem4Pawns BGI;

  if (LimitClientCallSpeed() || bDrainingArtifactActive) return;
  if (Pawn != None) {
    BGI = BattleGenInvItem4Pawns (Pawn.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI != None) {
      if (BGI.ActiveArtifactsLength > 0) {
        SelectedArtifact++;
        if (SelectedArtifact >= BGI.ActiveArtifactsLength) SelectedArtifact = 0; 
      }
      SelectedArtifactName = BGI.GetArtifact (SelectedArtifact).ArtifactDescription();
      SelectedArtifactCost = BGI.GetArtifact (SelectedArtifact).ArtifactCostDescription();
    }
  }
}

reliable server function UseArtifact ()
{
  local BattleGenInvItem4Pawns BGI;
  local BattleArtifact BAF;
  local UTPawn P;
  local BPRIDATA BD;

  if (LimitClientCallSpeed()) return;
  BGI = BattleGenInvItem4Pawns (Pawn.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
  if (BGI != None) {
    BAF = BGI.GetArtifact (SelectedArtifact);
    if (BAF != None) {
      if (BattleArtifactInstant(BAF) != None) { // Instant artifact
        P = UTPawn (Pawn);
        if (P != None) {
          BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
          if (BD.Mana >= BattleArtifactInstant(BAF).ManaUsage) {
            BD.Mana -= BattleArtifactInstant(BAF).ManaUsage;
            // Make sure to update the PRI before calling ActivateInstantArtifact!
            class'BattleStaticFunctions'.static.WriteBPRI (PlayerReplicationInfo, BD);
            BattleArtifactInstant(BAF).ActivateInstantArtifact (P);
          } else {
            class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You have"@BD.Mana@"Mana but you need"@
                                                BattleArtifactInstant(BAF).ManaUsage@"Mana for"@BAF.ArtifactDescription());
          }
        }
      } else if (BattleArtifactDraining(BAF) != None) { // Draining artifact
        P = UTPawn (Pawn);
        if (P != None) {
          if (!bDrainingArtifactActive) { // Activate artifact
            BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
            if (BD.Mana >= BattleArtifactDraining(BAF).ManaUsagePerSecond) {
              BattleArtifactDraining(BAF).StartDrainingArtifact (P);
              bDrainingArtifactActive = true;
            } else {
              class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You have"@BD.Mana@"Mana but you need"@
                           BattleArtifactDraining(BAF).ManaUsagePerSecond@"Mana for 1 second of"@BAF.ArtifactDescription());
            }
          } else { // Deactivate artifact
            BattleArtifactDraining(BAF).StopDrainingArtifact (P, false);
            bDrainingArtifactActive = false;
          }
        }      
      }
    }
  }
}

reliable server function UpdateCostData ()
{
  if (LimitClientCallSpeed()) return;
  DoGetPlayerDataFromServer (name (PlayerReplicationInfo.PlayerName));
}

reliable server function BuyAbility (int AbilityIndex)
{
  local BPRIDATA BD;
  local bool b;

  if (LimitClientCallSpeed()) return;
  if (AbilityIndex < 0 || AbilityIndex >= 100) return; // Tip from Shambler against exploits
  BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
  if (BD.BPD!=None && BD.BPD.BPBD!=None) {
    b = BD.BPD.BPBD.PlayerBuildData_Buy_Allowed (PlayerReplicationInfo, PlayerAbilityLevels, AbilityIndex);
    if (b) {
      BD.BPD.BPBD.PlayerBuildData_Buy (name (PlayerReplicationInfo.PlayerName), AbilityIndex);
      DoGetPlayerDataFromServer (name (PlayerReplicationInfo.PlayerName));
    }
  }
}

reliable server function SellAbility (int AbilityIndex) // Sells all abilities now
{
  local BPRIDATA BD;

  if (LimitClientCallSpeed()) return;
  if (AbilityIndex < 0 || AbilityIndex >= 100) return; // Tip from Shambler against exploits
  BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
  if (BD.BPD!=None && BD.BPD.BPBD!=None) {
    BD.BPD.BPBD.PlayerBuildData_SellAll (name (PlayerReplicationInfo.PlayerName));
    DoGetPlayerDataFromServer (name (PlayerReplicationInfo.PlayerName));
  }
}

function DoGetPlayerDataFromServer (name ID)
{
  local BPRIDATA BD;
  local int newval;
  local int i;
  local BattleAbility BA;
  local BattleRPG BRPG;

  BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
  if (BD.BPD!=None && BD.BPD.BPBD!=None) {
    BD.BPD.BPBD.GetPlayerBuildData (PlayerAbilityLevels, ID);
    for (i=0; i<ReplicatedDynamicAbilitiesLength; i++) {
      BRPG = BD.BPD.BRPG;
      if (BD.BPD.BPBD.PlayerBuildData_Buy_Allowed (PlayerReplicationInfo, PlayerAbilityLevels, i)) {
        BA = BRPG.AvailableAbilities[i];
        newval = BA.Cost (PlayerAbilityLevels[i]+1);
      } else if (PlayerAbilityLevels[i] == BRPG.AvailableAbilities[i].MaxLevel()){
        newval = -1;
      } else {
        newval = 0;
      }
      if (PlayerNextAbilitiesCost[i] != newval) {
        PlayerNextAbilitiesCost[i] = newval;
      }
    }
  }
}

reliable server function DoGetDataFromServer (name ID)
{
  local BPRIDATA BD;
  local BattleRPG BRPG;
  local int i;

  if (!LocalDataInitialized) {
    if (LimitClientCallSpeed()) return;
    BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
    if (BD.BPD!=None) {
      BRPG = BD.BPD.BRPG;
      if (BRPG != None) {
        RPGDollarsPerLevel = BRPG.RPGDollarsPerLevel;
        ReplicatedDynamicAbilitiesLength = BRPG.DynamicAbilities.Length;
        for (i=0; i<BRPG.DYnamicAbilities.Length; i++) {
          ReplicatedDynamicAbilities[i] = BRPG.DynamicAbilities[i];
        }
        if (ReplicatedDynamicAbilitiesLength!=0) {
          DoGetPlayerDataFromServer (ID);
          LocalDataInitialized = true; // Preparing replication succeeded.
        }
      }
    }
  }
}

simulated function GetDataFromServer (name ID)
{
  local BattleAbility BA;
  local int i;
  
  if (Countdown > 0) {
    Countdown--;
    return;
  } else {
    Countdown = 25; // Execute local logic once every 25 ticks
  }
  if (!LocalDataInitialized) {
    DoGetDataFromServer(ID);
  }
  if (LocalDataInitialized && !AfterLocalDataInitialized) {
    AfterLocalDataInitialized = true;
    for (i=0; i<ReplicatedDynamicAbilitiesLength; i++) {
      BA = new ReplicatedDynamicAbilities[i].AbilityClass;
      BA.AbilityName = ReplicatedDynamicAbilities[i].AbilityName;
      BA.AbilityDescription = ReplicatedDynamicAbilities[i].AbilityDescription;
      BA.AbilityMaxLevel = ReplicatedDynamicAbilities[i].AbilityMaxLevel;
      BA.AbilityLevel1Cost = ReplicatedDynamicAbilities[i].AbilityLevel1Cost;
      BA.AbilityCostIncreasePerLevel = ReplicatedDynamicAbilities[i].AbilityCostIncreasePerLevel;
      AvailableAbilities.AddItem (BA);
    }
`if(`isdefined(BRPG_ShowGetDataFromServer))
    `Log ("AfterLocalDataInitialized Role:"@Role);
    `Log ("AfterLocalDataInitialized ReplicatedDynamicAbilitiesLength:"@ReplicatedDynamicAbilitiesLength);
    for (i=0; i<ReplicatedDynamicAbilitiesLength; i++) {
      `Log ("AfterLocalDataInitialized ReplicatedDynamicAbilities Class:"@string(ReplicatedDynamicAbilities[i].AbilityClass));
      `Log ("AfterLocalDataInitialized ReplicatedDynamicAbilities Name:"@ReplicatedDynamicAbilities[i].AbilityName);
      `Log ("AfterLocalDataInitialized ReplicatedDynamicAbilities Description:"@ReplicatedDynamicAbilities[i].AbilityDescription);
      `Log ("AfterLocalDataInitialized PlayerAbilityLevels Level:"@PlayerAbilityLevels[i]);
    }
`endif
  }
}

simulated function string DetermineStatPoints ()
{
  local BPRIDATA BD;
  local int RPGDollars;
  local int Spend;
  local int i;

  BD = class'BattleStaticFunctions'.static.ReadBPRI (PlayerReplicationInfo);
  RPGDollars = BD.Level * RPGDollarsPerLevel;
  for (i=0; i<ReplicatedDynamicAbilitiesLength; i++) {
    Spend += AvailableAbilities[i].TotalCost(PlayerAbilityLevels[i]);
  }
  return "Available RPG$:" @ string(RPGDollars-Spend) @ "(spent:" @ Spend $ ")";
}

simulated function string DetermineAbilityList ()
{
  local string Result;
  local int i;
  local bool bSome;
  
  Result = "Your abilities:" $ chr(13) $ chr(10);
  for (i=0; i<ReplicatedDynamicAbilitiesLength; i++) {
    if (PlayerAbilityLevels[i] > 0) {
      bSome = true;
      Result = Result $ AvailableAbilities[i].AbilityName;
      Result = Result $ ": " $ PlayerAbilityLevels[i] $ " " $ chr(13) $ chr(10);
    }
  }
  if (!bSome) {
    Result = "You do not have any abilities yet.";
    Result = Result @ "Select an ability and press BUY to buy abilities.";
    Result = Result @ "Please read the desctiption carefully, some abilities have requirements before you can buy them.";
  }
  return Result;
}

simulated event PlayerTick (float deltatime)
{
  local PlayerReplicationInfo PRI;
  local name n;
//  local Pawn P;

  Super.PlayerTick (deltatime);

  if (BMM != None && BMM.Combo_Ability != None) {
    if (ReplicatedDynamicAbilitiesLength > 0) {
       ComboCtr++;
       if (ComboCtr==10) {
         BMM.InitCombo();
         ComboCtr = 0;
       }
    }
    UICurrentAbility = BMM.Combo_Ability.ComboList.Index;
    if (UICurrentAbility<0) UICurrentAbility=0;
  }
  
  // Only relevant on the client 
  if (WorldInfo.NetMode == NM_DedicatedServer) {
    return;
  }

  if (UICurrentAbility < 0) UICurrentAbility = ReplicatedDynamicAbilitiesLength - 1;
  if (UICurrentAbility >= ReplicatedDynamicAbilitiesLength) UICurrentAbility = 0;
  if (AvailableAbilities.length > 0) {
    PanelAbility = "BattleRPG"@`BRPG_Version;
    PanelAbilityDescription = AvailableAbilities[UICurrentAbility].AbilityName $ ":" $ chr(13) $ chr(10);
    PanelAbilityDescription $= AvailableAbilities[UICurrentAbility].Description();
    PanelStatPoints = DetermineStatPoints();
    PanelAbilityList = DetermineAbilityList();
  }
  MenuVisible = false;

  PRI = PlayerReplicationInfo;  
  n = name (PRI.PlayerName); // Somehow this refuses to work: n = class'BattlePersistentPlayerDatabase'.static.PRI2Name (PRI);
  GetDataFromServer (n);

  // Replace the HUD
  if (myHud!=None) {
    if (myHud.class == class'UTOnslaughtHud') {
      ClientSetHUD (Class'BattleHUDOnslaught', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else  if (myHud.class == class'UTCTFHUD') {
      ClientSetHUD (Class'BattleHUDCTF', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else  if (myHud.class == class'UTVehicleCTFHUD') {
      ClientSetHUD (Class'BattleHUDVCTF', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else  if (myHud.class == class'UTDuelHUD') {
      ClientSetHUD (Class'BattleHUDDuel', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else  if (myHud.class == class'UTTeamHUD') {
      ClientSetHUD (Class'BattleHUDTeam', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else if (myHud.class == class'UTHUD') {
      ClientSetHUD (Class'BattleHUD', Worldinfo.Game.Scoreboardtype);         
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
`if(`isdefined(BRPG_Build4UT3Invasion))
    } else if (myHud.class == class'InvasionHUD') {
      ClientSetHUD (Class'BattleHUDInvasion', Worldinfo.Game.Scoreboardtype);
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else if (myHud.class == class'UTPHud') {
      ClientSetHUD (Class'BattleHUDInvasion', Worldinfo.Game.Scoreboardtype);
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
    } else if (String(myHud.class) == "UTPHud") {
      ClientSetHUD (Class'BattleHUDInvasion', Worldinfo.Game.Scoreboardtype);
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
`endif
`if(`isdefined(BRPG_Build4GaltanorsInvasion))
    } else if (myHud.class == class'InvHUD') {
      ClientSetHUD (Class'BattleHUDInvasion', Worldinfo.Game.Scoreboardtype);
      LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
`endif
   }
  }

  // Create a BattleInteraction and connect it to the BattlePlayerController  
  if (BI == None){
    BI = New(Self) class'BattleInteraction';
    Interactions.Insert(0,1);
    Interactions[0] = BI;
    BI.Init();
    BI.BPC = Self; // Connect the other way as well so the interaction can find the playercontroller
  }

//  foreach WorldInfo.AllPawns(class'Pawn', P) {
//    if (P.Weapon != None) {
//      P.Weapon.Tick(deltatime);
//    }
//  }
}

reliable client function ShowMessage (int Type, string Msg)
{
  local BattleMessage_Specs StrObj;

  StrObj = New class'BattleMessage_Specs';
  StrObj.Message = Msg;
  ReceiveLocalizedMessage (class'BattleMessage', Type, None, None, StrObj);
}

reliable client function Slowdown (Pawn P, int TheLevel)
{
  if (P != None) {
    P.CustomTimeDilation = 0.50 - 0.05 * Min (5, TheLevel);
  }
}

reliable client function Speedup (Pawn P)
{
  if (P != None) {
    P.CustomTimeDilation = 1.0;
  }
}

reliable server function Message2PC (string Type, string Msg)
{
  ShowMessage (0, Msg);
//  class'BattleStaticFunctions'.static.Message2PC (Self, Type, Msg);
}

defaultproperties
{
  Name="BattlePlayerController"
}