/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactInstant_MagicWeaponMaker extends BattleArtifactInstant config (BattleRPG);

function ActivateInstantArtifact (UTPawn P)
{
  local UTWeapon UTW;
  local BWEAPDATA BW;
  local PlayerController PC;
  local BattleRPG BRPG;
  local PlayerReplicationInfo PRI;
  local BPRIDATA BD;

  if (P != None && WorldInfo != None) {
    UTW = UTWeapon(P.Weapon);
    if (UTW != None) {
      BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (WorldInfo);  
      if (BRPG != None) {
        BRPG.CreateWeaponMagic (UTW, BW.ActiveBWM, BW.ActiveBWMLevel, "alwaysmagic");
        PC = PlayerController (P.Owner);
        if (BW.ActiveBWMLevel != 0 && BW.ActiveBWM != None) {
          class'BattleStaticFunctions'.static.WriteWEAP (UTW, BW);
          class'BattleStaticFunctions'.static.Message2Pawn (P, "newweaponmagic", "Your weapon is now: "@BW.ActiveBWM.MagicDescription (BW.ActiveBWMLevel));
        } else {
          class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "Failed to generate a magic weapon"); // E.g. due to settings made by the server admin
          // Give the player a refund
          PRI = PC.PlayerReplicationInfo;
          if (PRI != None) {
            BD = class'BattleStaticFunctions'.static.ReadBPRI (PRI);
            BD.Mana = BD.Mana + ManaUsage;
            class'BattleStaticFunctions'.static.WriteBPRI (PRI, BD);
          }
        }
      }
    }
  }
}

defaultproperties
{
  ArtifactName = "Magic Weapon Maker";
  ManaUsage = 25;
}