/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_HealthBonus extends BattleAbility config (BattleRPG);

function ServerModifyPlayer (UTPawn P, int Level)
{
  P.Health = P.default.Health + Level * 10;
  P.HealthMax = P.default.Health + Level * 10; // P.default.HealthMax does not do what one would expect
}

defaultproperties
{
  AbilityName = "Health Bonus";
  AbilityDescription = "Gives you 10 extra health per level every time you spawn.";
  AbilityMaxLevel = 10;
  AbilityLevel1Cost = 5;
  AbilityCostIncreasePerLevel = 0;
}