/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Bounce extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  if (ClassIsChildOf(W.Class, class'UTWeap_Avril_Content')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_BioRifle_Content')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_Enforcer')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_FlakCannon')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_ImpactHammer')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_SniperRifle')) return false;
  return true;
}

function ModifyProjectile (Projectile PR, int Level)
{
  if (BattleProjectile_Rocket (PR) != None) {
    BattleProjectile_Rocket (PR).bBouncing = true;
  }
  if (BattleProjectile_LoadedRocket (PR) != None) {
    BattleProjectile_LoadedRocket (PR).bBouncing = true;
  }
  if (BattleProjectile_SeekingRocket (PR) != None) {
    BattleProjectile_SeekingRocket (PR).bBouncing = true;
  }
  if (BattleProjectile_LinkPlasma (PR) != None) {
    BattleProjectile_LinkPlasma (PR).bBouncing = true;
  }
  if (BattleProjectile_ShockBall (PR) != None) {
    BattleProjectile_ShockBall (PR).bBouncing = true;
  }
  if (BattleProjectile_StingerShard (PR) != None) {
    BattleProjectile_StingerShard (PR).bBouncing = true;
  }
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * (1.0 + Level * 0.03); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Bounce";
  MagicMaxLevel = 10;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_LiquidPurple';
  bPositiveMagic = true;
  DamageChangePercentage = 3;
}