/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleMessage extends UTLocalMessage;

static function string GetString(
	optional int Switch,
	optional bool bPRI1HUD,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
  if (BattleMessage_Specs (OptionalObject) != None) {
    return BattleMessage_Specs (OptionalObject).Message;
  }
  return "???";
}

static simulated function ClientReceive(
	PlayerController P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	local UTHUD HUD;
	
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	HUD = UTHUD(P.myHUD);
	if ((HUD != None) && HUD.bIsSplitScreen && !HUD.bIsFirstPlayer)
	{
		return;
	}
	UTPlayerController(P).PlayAnnouncement(default.class, Switch);
}

static function bool ShouldBeRemoved(UTQueuedAnnouncement MyAnnouncement, class<UTLocalMessage> NewAnnouncementClass, int NewMessageIndex)
{
  return true;
}

static function SoundNodeWave AnnouncementSound(int MessageIndex, Object OptionalObject, PlayerController PC)
{
  return SoundNodeWave'A_Pickups.Generic.WAV.A_Pickups_Generic_ItemRespawn01';
}

defaultproperties
{
  MessageArea=2
  AnnouncementPriority=8
  bIsUnique=True
  DrawColor=(B=11,G=183,R=255,A=200)
  FontSize=2
  Name="Default__BattleMessage"
  ObjectArchetype=UTLocalMessage'UTGame.Default__UTLocalMessage'
}