/*
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleGenInvItem4Pawns extends Inventory dependson(BattleStaticFunctions);

var BattleAbility ActiveAbilities[100];
var int ActiveAbilityLevels[100];
var int ActiveAbilitiesLength;

var BattleArtifact ActiveArtifacts[100];
var int ActiveArtifactsLength;

var BattleWeaponMagic CurrentBWM;
var int CurrentBWMLevel;

function BattleAbility GetAbility (int i)
{
  return ActiveAbilities[i];
}

function BattleArtifact GetArtifact (int i)
{
  return ActiveArtifacts[i];
}

function int GetAbilityLevel (int i)
{
  return ActiveAbilityLevels[i];
}

simulated function PostBeginPlay()
{
  super.PostBeginPlay();
  if (WorldInfo.NetMode != NM_Client) {
    SetTimer (1.0, True, 'ServerTimer');
  }
  if (WorldInfo.NetMode != NM_Client) {
    SetTimer (0.1, True, 'RapidServerTimer');
  }
  if (WorldInfo.NetMode != NM_DedicatedServer) {
    SetTimer (1.0, True, 'ClientTimer'); 
  }
}

function AddActiveAbility (BattleAbility BA, int Level)
{
  ActiveAbilities[ActiveAbilitiesLength] = BA;
  ActiveAbilityLevels[ActiveAbilitiesLength] = Level;
  ActiveAbilitiesLength++;  
}

function AddActiveArtifact (BattleArtifact BAF)
{
  ActiveArtifacts[ActiveArtifactsLength] = BAF;
  ActiveArtifactsLength++;  
}

function ServerTimer ()
{
  local BattlePlayerController BPC;
  local BattleArtifact BAF;
  local BWEAPDATA BWEAP;
  local BPRIDATA BD;
  local int i;

  if (Pawn(Owner) != None) {
    if (UTPawn(Owner)!=None) {
      // Handle ability timers
      for (i=0; i<ActiveAbilitiesLength; i++) {
        ActiveAbilities[i].ServerTimer (UTPawn(Owner), ActiveAbilityLevels[i]);
      }

      // Handle weapon magic timer (only the one of the active weapon, the rest is asleep)
      if (UTPawn(Owner).Weapon != None && UTWeapon (UTPawn(Owner).Weapon) != None) {
        BWEAP = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon (UTPawn(Owner).Weapon));
        if (BWEAP.ActiveBWM != None) {
          BWEAP.ActiveBWM.ServerTimer (UTPawn(Owner), BWEAP.ActiveBWMLevel);
        }
      }

      // Handle draining artifact Mana consumption and ServerTimer
      BPC = BattlePlayerController (UTPawn(Owner).Owner);
      if (BPC==None && UTPawn(Owner).Owner != None && UTPawn(Owner).DrivenVehicle != None) {
        BPC = BattlePlayerController (UTPawn(Owner).DrivenVehicle.Controller);
      }
      if (BPC != None && BPC.bDrainingArtifactActive && BPC.PlayerReplicationInfo != None) {
        BAF = GetArtifact (BPC.SelectedArtifact);
        if (BattleArtifactDraining(BAF) != None) {
          BD = class'BattleStaticFunctions'.static.ReadBPRI (BPC.PlayerReplicationInfo);
          if (BD.Mana >= BattleArtifactDraining(BAF).ManaUsagePerSecond) {
            BD.Mana -= BattleArtifactDraining(BAF).ManaUsagePerSecond;
            class'BattleStaticFunctions'.static.WriteBPRI (BPC.PlayerReplicationInfo, BD);
            BattleArtifactDraining(BAF).ServerTimer (UTPawn(Owner));
          } else { // Plater ran out of Mana
            BattleArtifactDraining(BAF).StopDrainingArtifact (UTPawn(Owner), false);
            BPC.bDrainingArtifactActive = false;
          }
        }
      }
    }
  }   
}

function RapidServerTimer ()
{
  local BattlePlayerController BPC;
  local BattleArtifact BAF;
  local BPRIDATA BD;
  local UTWeapon W;
  local BWEAPDATA BWEAP;
  local int i;

  if (UTPawn(Owner)!=None) {
    // Handle ability RapidServerTimers
    for (i=0; i<ActiveAbilitiesLength; i++) {
      ActiveAbilities[i].RapidServerTimer (UTPawn(Owner), ActiveAbilityLevels[i]);
    }

    // Handle weapon magic timer (only the one of the active weapon, the rest is asleep)
    if (UTPawn(Owner).Weapon != None && UTWeapon (UTPawn(Owner).Weapon) != None) {
      BWEAP = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon (UTPawn(Owner).Weapon));
      if (BWEAP.ActiveBWM != None) {
        BWEAP.ActiveBWM.RapidServerTimer (UTPawn(Owner), BWEAP.ActiveBWMLevel);
      }
    }

    // Handle draining artifact RapidServerTimer
    BPC = BattlePlayerController (UTPawn(Owner).Owner);
    if (BPC != None && BPC.bDrainingArtifactActive && BPC.PlayerReplicationInfo != None) {
      BAF = GetArtifact (BPC.SelectedArtifact);
      if (BattleArtifactDraining(BAF) != None) {
        BD = class'BattleStaticFunctions'.static.ReadBPRI (BPC.PlayerReplicationInfo);
        if (BD.Mana >= BattleArtifactDraining(BAF).ManaUsagePerSecond) {
          BattleArtifactDraining(BAF).RapidServerTimer (UTPawn(Owner));
        }
      }
    }
    
    if (BPC != None && UTPawn(Owner)!=None) {
      // Record weapon and weapon magic for weapon resurrection
      W = UTWeapon (UTPawn(Owner).Weapon);
      if (W != None  && class'BattleStaticFunctions'.static.HasWEAP (W)) {
        If (W.Class != BPC.LastActiveWeapon) BPC.LastActiveWeapon = W.Class;
        BWEAP = class'BattleStaticFunctions'.static.ReadWEAP (w);
        if (BWEAP.ActiveBWMLevel != BPC.LastActiveWeaponMagicLevel) BPC.LastActiveWeaponMagicLevel = BWEAP.ActiveBWMLevel;
        if (BWEAP.ActiveBWMLevel != 0) {
          if (BWEAP.ActiveBWM.Class != BPC.LastActiveWeaponMagic) BPC.LastActiveWeaponMagic = BWEAP.ActiveBWM.Class;
        }
      }
    }
  }
}

simulated function ClientTimer ()
{
  ClearTimer ('ClientTimer');
}

simulated event Tick(float DeltaTime)
{
  local PlayerController PC;
  local BPRIDATA BD;
  local BWEAPDATA BWEAP;

  // Handle dodge jumping (needs to be handled on the client)
  if (UTPawn(Owner) != None && UTPawn(Owner).bDodging) {
    PC = PlayerController (Owner.Owner);
    if (PC != None && PC.PlayerReplicationInfo != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.bAllowDodgeJumping) { 
        UTPawn(Owner).bReadyToDoubleJump = True; 
        UTPawn(Owner).bDodging = False;    
      }
    }
  }  

  // Handle magic changes (caused by weapon switching), need to look into entering and leaving vehicles
  if (UTPawn(Owner) != None && UTPawn(Owner).Weapon != None && UTWeapon (UTPawn(Owner).Weapon) != None) {
    BWEAP = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon (UTPawn(Owner).Weapon));
    if (BWEAP.ActiveBWM != CurrentBWM || BWEAP.ActiveBWMLevel != CurrentBWMLevel) {
      if (CurrentBWM != None) CurrentBWM.RemoveMagic (UTPawn(Owner), CurrentBWMLevel); // remove old magic
      CurrentBWM = BWEAP.ActiveBWM;
      CurrentBWMLevel = BWEAP.ActiveBWMLevel;
      if (BWEAP.ActiveBWM != None) {
        BWEAP.ActiveBWM.AddMagic (UTPawn(Owner), BWEAP.ActiveBWMLevel); // add new magic
      }
    }

	if (UTPawn(Owner) != None && UTWeapon(UTPawn(Owner).Weapon) != None && BWEAP.ActiveBWM != None && BWEAP.ActiveBWM.MagicMaterial != None) {
      if (BWEAP.ActiveBWM.MagicMaterial != BWEAP.MagicMaterial) {
        BWEAP.MagicMaterial = BWEAP.ActiveBWM.MagicMaterial;
        class'BattleStaticFunctions'.static.WriteWEAP (UTWeapon (UTPawn(Owner).Weapon), BWEAP);
      }
    }
  }
}

defaultproperties
{
  Name="BattleGenInvItem4Pawns"
}