/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Quantum extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true;
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local BattleWeaponMagic_Quantum_InvItem Inv;
  local PlayerController PC;
  local BPRIDATA BD;
  local BWEAPDATA BW;

  if (InjuredPawn == None) return;
  if (UTTeamGame(P.WorldInfo.Game) != None && P != InjuredPawn && P.GetTeam() == InjuredPawn.GetTeam()) return; // You can quantum yourself but not your team mates

  if (InjuredPawn != None && UTWeapon(InjuredPawn.Weapon) != None) {
    BW = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon(InjuredPawn.Weapon));
    if (BW.ActiveBWM != None && BW.ActiveBWM.Class == class'BattleWeaponMagic_Reflection') {
      Inv = BattleWeaponMagic_Quantum_InvItem (P.FindInventoryType (class'BattleWeaponMagic_Quantum_InvItem'));
      if (Inv == None) {
        Inv = P.Spawn (class'BattleWeaponMagic_Quantum_InvItem', InjuredPawn);
        Inv.GiveTo (P);
      }
      if (Inv == None) return;
      Inv.Level = Max (Inv.Level, Level); // Maximize the level (in case multiple people hit a player with Quantum)
      Inv.Lifespan = Max (Inv.Lifespan, 2 + Level);
      PC = PlayerController (InjuredPawn.Owner);
      if (PC != None) {
        Inv.InstigatorController = PC;
      }
      Damage = Damage * (1.0 + Level * 0.02); // It's positive magic, so we do some extra damage as well
      return;
    }
  }

  if (Damage != 0 && P != None && P.Owner != None) {
    PC = PlayerController (P.Owner);
    if (PC != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.Mana >= 2 * Level) { // Takes Mana per hit
        Inv = BattleWeaponMagic_Quantum_InvItem (InjuredPawn.FindInventoryType (class'BattleWeaponMagic_Quantum_InvItem'));
        if (Inv == None) {
          BD.Mana -= 2 * Level; // Only burn mana on first shot
          class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
          Inv = InjuredPawn.Spawn (class'BattleWeaponMagic_Quantum_InvItem', InjuredPawn);
	      Inv.GiveTo (InjuredPawn);
        }
        if (Inv == None) return;
        Inv.Level = Max (Inv.Level, Level); // Maximize the level (in case multiple people hit a player with Quantum)
        Inv.Lifespan = Max (Inv.Lifespan, 2 + Level);
        Inv.InstigatorController = PC;
      }
    }
  }

  Damage = Damage * (1.0 + Level * 0.02); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Quantum";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_InfGreen';
  bPositiveMagic = true;
  DamageChangePercentage = 2;
}