/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactInstant_ManaGambling extends BattleArtifactInstant config (BattleRPG);

function ActivateInstantArtifact (UTPawn P)
{
  local PlayerController PC;
  local PlayerReplicationInfo PRI;
  local BPRIDATA BD;

  PC = PlayerController (P.Owner);
  if (PC != None) {
    PRI = PC.PlayerReplicationInfo;
    if (PRI != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PRI);
      BD.Mana = BD.Mana + ManaUsage; // They never do this in real casinos
      // Double or nothing
      if (BD.Mana <= 500) { // 1000 being the theoretical limit to this
        If (Rand(2)==1) {
          BD.Mana *= 2;
          class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You won and doubled your Mana");
        } else {
          BD.Mana = 0;
          class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You lost all your Mana");
        }
      } else {
        class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You got kicked out of the Mana casino");
      }
      class'BattleStaticFunctions'.static.WriteBPRI (PRI, BD);
    }
  }
}

defaultproperties
{
  ArtifactName = "Mana Gambling";
  ManaUsage = 25;
}