/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactDraining_DoubleDamage extends BattleArtifactDraining config (BattleRPG);

function StartDrainingArtifact (UTPawn P)
{
  local PlayerController PC;

  PC = PlayerController (P.Owner);
  if (PC==None && P.Owner != None && P.DrivenVehicle != None) {
    PC = PlayerController (P.DrivenVehicle.Controller);
  }
  class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You feel very strong");
}

function StopDrainingArtifact (UTPawn P, bool bSilent)
{
  local PlayerController PC;

  PC = PlayerController (P.Owner);
  if (PC==None && P.Owner != None && P.DrivenVehicle != None) {
    PC = PlayerController (P.DrivenVehicle.Controller);
  }
  class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You feel a tad weak");
}


function DamageToOtherPawn (UTPawn P, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * 2;  
}

defaultproperties
{
  ArtifactName = "Double Damage";
  ManaUsagePerSecond = 5;
}